/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.result.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.geode.management.internal.cli.result.model.AbstractResultModel;

public class TabularResultModel
extends AbstractResultModel {
    private Map<String, List<String>> table = new LinkedHashMap<String, List<String>>();

    TabularResultModel() {
    }

    public TabularResultModel accumulate(String column, String value) {
        if (this.table.containsKey(column)) {
            this.table.get(column).add(value);
        } else {
            ArrayList<String> list = new ArrayList<String>();
            list.add(value);
            this.table.put(column, list);
        }
        return this;
    }

    public void addMemberStatusResultRow(String member, String result, String message) {
        if (member != null) {
            this.accumulate("Member", member);
        }
        this.accumulate("Result", result);
        this.accumulate("Message", message);
    }

    @Override
    public Map<String, List<String>> getContent() {
        return this.table;
    }

    public void setColumnHeader(String ... columnHeaders) {
        for (String columnHeader : columnHeaders) {
            this.table.put(columnHeader, new ArrayList());
        }
    }

    public void addRow(String ... values) {
        if (values.length != this.table.size()) {
            throw new IllegalStateException("row size is different than the column header size.");
        }
        List<String> columnHeaders = this.getHeaders();
        for (int i = 0; i < values.length; ++i) {
            this.table.get(columnHeaders.get(i)).add(values[i]);
        }
    }

    @JsonIgnore
    public List<String> getHeaders() {
        ArrayList<String> headers = new ArrayList<String>();
        headers.addAll(this.table.keySet());
        return headers;
    }

    @JsonIgnore
    public String getValue(String columnName, int rowIndex) {
        return this.table.get(columnName).get(rowIndex);
    }

    @JsonIgnore
    public int getColumnSize() {
        return this.table.size();
    }

    @JsonIgnore
    public int getRowSize() {
        if (this.table.size() == 0) {
            return 0;
        }
        return this.table.values().iterator().next().size();
    }

    @JsonIgnore
    public List<String> getValuesInColumn(String header) {
        return this.table.get(header);
    }

    @JsonIgnore
    public List<String> getValuesInRow(int index) {
        List<String> headers = this.getHeaders();
        ArrayList<String> values = new ArrayList<String>();
        for (String header : headers) {
            values.add(this.table.get(header).get(index));
        }
        return values;
    }
}

