/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.result;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.SystemUtils;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.GfshParser;
import org.apache.geode.management.internal.cli.json.GfJsonObject;
import org.apache.geode.management.internal.cli.result.CommandResult;
import org.apache.geode.management.internal.cli.result.TableBuilder;
import org.apache.geode.management.internal.cli.result.model.AbstractResultModel;
import org.apache.geode.management.internal.cli.result.model.DataResultModel;
import org.apache.geode.management.internal.cli.result.model.InfoResultModel;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.cli.result.model.TabularResultModel;

public class ModelCommandResult
implements CommandResult {
    private static final String DO_NOT_USE_PERSISTED_FLAG = "The persisted flag is an artifact of the legacy model and should not be used ModelCommandResult.";
    private static final String FILE_LOGIC_NOT_YET_IMPLEMENTED = "File transfer logic has not yet been implemented in ModelCommandResult";
    private static final String CANNOT_PASS_GF_JSON_OBJECT_TO_MODEL_COMMAND_RESULT = "Cannot pass GfJsonObject to ModelCommandResult";
    private static final String CANNOT_USE_GF_JSON_OBJECT_FROM_MODEL_COMMAND_RESULT = "Cannot use GfJsonObject from ModelCommandResult";
    private ResultModel result;
    private List<String> commandOutput;
    private int commandOutputIndex;
    @Immutable
    private static final Map<String, List<String>> EMPTY_TABLE_MAP = Collections.unmodifiableMap(new LinkedHashMap());
    @Immutable
    private static final List<String> EMPTY_LIST = Collections.emptyList();

    public ModelCommandResult(ResultModel result) {
        this.result = result;
    }

    @Override
    public Path getFileToDownload() {
        return this.result.getFileToDownload();
    }

    @Override
    public boolean hasFileToDownload() {
        return this.getFileToDownload() != null;
    }

    @Override
    public Result.Status getStatus() {
        return this.result.getStatus();
    }

    @Override
    public void setStatus(Result.Status status) {
    }

    @Override
    public ResultModel getResultData() {
        return this.result;
    }

    @Override
    public void resetToFirstLine() {
        this.commandOutputIndex = 0;
    }

    @Override
    public boolean hasIncomingFiles() {
        return false;
    }

    @Override
    public int getNumTimesSaved() {
        return 0;
    }

    @Override
    public void saveIncomingFiles(String directory) throws IOException {
    }

    @Override
    public boolean hasNextLine() {
        if (this.commandOutput == null) {
            this.buildCommandOutput();
        }
        return this.commandOutputIndex < this.commandOutput.size();
    }

    @Override
    public String nextLine() {
        if (this.commandOutput == null) {
            this.buildCommandOutput();
        }
        return this.commandOutput.get(this.commandOutputIndex++);
    }

    @Override
    public String toJson() {
        return this.getResultData().toJson();
    }

    @Override
    public String getType() {
        return "model";
    }

    @Override
    public String getHeader() {
        return this.result.getHeader();
    }

    @Override
    public String getHeader(GfJsonObject gfJsonObject) {
        throw new IllegalArgumentException(CANNOT_PASS_GF_JSON_OBJECT_TO_MODEL_COMMAND_RESULT);
    }

    @Override
    public GfJsonObject getContent() {
        throw new IllegalArgumentException(CANNOT_USE_GF_JSON_OBJECT_FROM_MODEL_COMMAND_RESULT);
    }

    @Override
    public String getMessageFromContent() {
        List<InfoResultModel> infos = this.result.getInfoSections();
        if (infos.size() == 0) {
            return "";
        }
        Object messages = infos.get(0).getContent();
        return messages.stream().collect(Collectors.joining(". "));
    }

    @Override
    public String getErrorMessage() {
        return this.getMessageFromContent();
    }

    @Override
    public String getValueFromContent(String key) {
        return null;
    }

    @Override
    public List<String> getListFromContent(String key) {
        return null;
    }

    @Override
    public List<String> getColumnFromTableContent(String column, String tableId) {
        TabularResultModel table = this.result.getTableSection(tableId);
        if (table == null) {
            return EMPTY_LIST;
        }
        return (List)table.getContent().get(column);
    }

    @Override
    public Map<String, List<String>> getMapFromTableContent(String tableId) {
        TabularResultModel table = this.result.getTableSection(tableId);
        if (table == null) {
            return EMPTY_TABLE_MAP;
        }
        return table.getContent();
    }

    @Override
    public Map<String, String> getMapFromSection(String sectionID) {
        return this.result.getDataSection(sectionID).getContent();
    }

    @Override
    public String getFooter() {
        return this.result.getFooter();
    }

    @Override
    public boolean failedToPersist() {
        throw new IllegalArgumentException(DO_NOT_USE_PERSISTED_FLAG);
    }

    @Override
    public void setCommandPersisted(boolean commandPersisted) {
        throw new IllegalArgumentException(DO_NOT_USE_PERSISTED_FLAG);
    }

    @Override
    public void setFileToDownload(Path fileToDownload) {
        throw new NotImplementedException(FILE_LOGIC_NOT_YET_IMPLEMENTED);
    }

    @Override
    public List<String> getTableColumnValues(String columnName) {
        List<TabularResultModel> tables = this.result.getTableSections();
        if (tables.size() == 0) {
            return EMPTY_LIST;
        }
        return (List)tables.get(0).getContent().get(columnName);
    }

    @Override
    public List<String> getTableColumnValues(String sectionId, String columnName) {
        return (List)this.result.getTableSection(sectionId).getContent().get(columnName);
    }

    private void buildCommandOutput() {
        this.commandOutputIndex = 0;
        this.commandOutput = new ArrayList<String>();
        TableBuilder.Table resultTable = TableBuilder.newTable();
        this.addSpacedRowInTable(resultTable, this.result.getHeader());
        int index = 0;
        int sectionSize = this.result.getContent().size();
        for (AbstractResultModel section : this.result.getContent().values()) {
            ++index;
            if (section instanceof DataResultModel) {
                this.buildData(resultTable, (DataResultModel)section);
            } else if (section instanceof TabularResultModel) {
                this.buildTabularCommandOutput(resultTable, (TabularResultModel)section);
            } else if (section instanceof InfoResultModel) {
                this.buildInfoOrErrorCommandOutput(resultTable, (InfoResultModel)section);
            } else {
                throw new IllegalArgumentException("Unable to process output for " + section.getClass().getName());
            }
            if (index >= sectionSize) continue;
            this.addSpacedRowInTable(resultTable, SystemUtils.LINE_SEPARATOR);
        }
        this.addSpacedRowInTable(resultTable, this.result.getFooter());
        this.commandOutput.addAll(resultTable.buildTableList());
    }

    private void addHeaderInTable(TableBuilder.Table resultTable, ResultModel model) {
        String header = model.getHeader();
        if (header != null && !header.isEmpty()) {
            resultTable.newRow().newLeftCol(header);
            resultTable.newRow().newLeftCol("");
        }
    }

    private void addSpacedRowInTable(TableBuilder.Table resultTable, String row) {
        if (row != null && !row.isEmpty()) {
            resultTable.newRow().newLeftCol(row);
            resultTable.newRow().newLeftCol("");
        }
    }

    private void addRowInRowGroup(TableBuilder.RowGroup rowGroup, String row) {
        if (row != null && !row.isEmpty()) {
            rowGroup.newRow().newLeftCol(row);
        }
    }

    private void buildTabularCommandOutput(TableBuilder.Table resultTable, TabularResultModel model) {
        this.addSpacedRowInTable(resultTable, model.getHeader());
        resultTable.setColumnSeparator("   ");
        resultTable.setTabularResult(true);
        TableBuilder.RowGroup rowGroup = resultTable.newRowGroup();
        this.buildTable(rowGroup, model);
        this.addSpacedRowInTable(resultTable, model.getFooter());
    }

    private void buildTable(TableBuilder.RowGroup rowGroup, TabularResultModel model) {
        TableBuilder.Row headerRow = rowGroup.newRow();
        rowGroup.setColumnSeparator(" | ");
        rowGroup.newRowSeparator(Character.valueOf('-'), false);
        Object rows = model.getContent();
        if (!rows.isEmpty()) {
            rows.keySet().forEach(c -> headerRow.newCenterCol(c));
            int rowCount = ((List)rows.values().iterator().next()).size();
            for (int i = 0; i < rowCount; ++i) {
                TableBuilder.Row oneRow = rowGroup.newRow();
                for (String column : rows.keySet()) {
                    oneRow.newLeftCol(((List)rows.get(column)).get(i));
                }
            }
        }
    }

    private void buildData(TableBuilder.Table resultTable, DataResultModel section) {
        TableBuilder.RowGroup rowGroup = resultTable.newRowGroup();
        rowGroup.setColumnSeparator(" : ");
        this.addRowInRowGroup(rowGroup, section.getHeader());
        for (Map.Entry entry : section.getContent().entrySet()) {
            TableBuilder.Row newRow = rowGroup.newRow();
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            String[] values = ((String)entry.getValue()).split(GfshParser.LINE_SEPARATOR);
            if (values.length == 1) {
                newRow.newLeftCol(key).newLeftCol(values[0]);
                continue;
            }
            if (values.length != 0) {
                newRow.newLeftCol(key).newLeftCol(values[0]);
                for (int i = 1; i < values.length; ++i) {
                    newRow = rowGroup.newRow();
                    newRow.setColumnSeparator("   ");
                    newRow.newLeftCol("").newLeftCol(values[i]);
                }
                continue;
            }
            newRow.newLeftCol(key).newLeftCol("");
        }
        this.addRowInRowGroup(rowGroup, section.getFooter());
    }

    private void buildInfoOrErrorCommandOutput(TableBuilder.Table resultTable, InfoResultModel model) {
        TableBuilder.RowGroup rowGroup = resultTable.newRowGroup();
        this.addRowInRowGroup(rowGroup, model.getHeader());
        model.getContent().forEach(c -> rowGroup.newRow().newLeftCol(c));
        this.addRowInRowGroup(rowGroup, model.getFooter());
    }
}

