/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.HashedMap;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.configuration.CacheElement;
import org.apache.geode.cache.configuration.RegionConfig;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.management.cli.CliFunction;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.configuration.realizers.ConfigurationRealizer;
import org.apache.geode.management.internal.configuration.realizers.RegionConfigRealizer;

public class UpdateCacheFunction
extends CliFunction<List> {
    @Immutable
    private static final Map<Class, ConfigurationRealizer> realizers = new HashedMap();

    @Override
    public CliFunctionResult executeFunction(FunctionContext<List> context) throws Exception {
        CacheElement cacheElement = (CacheElement)context.getArguments().get(0);
        CacheElementOperation operation = (CacheElementOperation)((Object)context.getArguments().get(1));
        Cache cache = context.getCache();
        ConfigurationRealizer realizer = realizers.get(cacheElement.getClass());
        switch (operation) {
            case ADD: {
                realizer.create(cacheElement, cache);
                break;
            }
            case DELETE: {
                realizer.delete(cacheElement, cache);
                break;
            }
            case UPDATE: {
                realizer.update(cacheElement, cache);
            }
        }
        return new CliFunctionResult(context.getMemberName(), CliFunctionResult.StatusState.OK, "success");
    }

    static {
        realizers.put(RegionConfig.class, new RegionConfigRealizer());
    }

    public static enum CacheElementOperation {
        ADD,
        DELETE,
        UPDATE;

    }
}

