/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.ClassPathLoader;
import org.apache.geode.internal.DeployedJar;
import org.apache.geode.internal.JarDeployer;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.execute.InternalFunction;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.logging.log4j.Logger;

public class UndeployFunction
implements InternalFunction {
    private static final Logger logger = LogService.getLogger();
    public static final String ID = UndeployFunction.class.getName();
    private static final long serialVersionUID = 1L;

    @Override
    public void execute(FunctionContext context) {
        String memberId = "";
        try {
            List jarNamesToUndeploy;
            Object[] args = (Object[])context.getArguments();
            Object[] jarFilenameList = (String[])args[0];
            InternalCache cache = (InternalCache)context.getCache();
            JarDeployer jarDeployer = ClassPathLoader.getLatest().getJarDeployer();
            DistributedMember member = cache.getDistributedSystem().getDistributedMember();
            memberId = member.getId();
            if (!member.getName().equals("")) {
                memberId = member.getName();
            }
            if (ArrayUtils.isNotEmpty((Object[])jarFilenameList)) {
                jarNamesToUndeploy = Arrays.stream(jarFilenameList).collect(Collectors.toList());
            } else {
                List<DeployedJar> jarClassLoaders = jarDeployer.findDeployedJars();
                jarNamesToUndeploy = jarClassLoaders.stream().map(l -> l.getJarName()).collect(Collectors.toList());
            }
            HashMap<String, String> undeployedJars = new HashMap<String, String>();
            for (String jarName : jarNamesToUndeploy) {
                String jarLocation;
                try {
                    jarLocation = ClassPathLoader.getLatest().getJarDeployer().undeploy(jarName);
                }
                catch (IOException | IllegalArgumentException iaex) {
                    jarLocation = iaex.getMessage();
                }
                undeployedJars.put(jarName, jarLocation);
            }
            CliFunctionResult result = new CliFunctionResult(memberId, undeployedJars, null);
            context.getResultSender().lastResult(result);
        }
        catch (Exception cce) {
            logger.error(cce.getMessage(), (Throwable)cce);
            CliFunctionResult result = new CliFunctionResult(memberId, false, null);
            context.getResultSender().lastResult(result);
        }
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public boolean hasResult() {
        return true;
    }

    @Override
    public boolean optimizeForWrite() {
        return false;
    }

    @Override
    public boolean isHA() {
        return false;
    }
}

