/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.geode.cache.AttributesMutator;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheListener;
import org.apache.geode.cache.CacheLoader;
import org.apache.geode.cache.CacheWriter;
import org.apache.geode.cache.CustomExpiry;
import org.apache.geode.cache.ExpirationAction;
import org.apache.geode.cache.ExpirationAttributes;
import org.apache.geode.cache.configuration.DeclarableType;
import org.apache.geode.cache.configuration.RegionAttributesType;
import org.apache.geode.cache.configuration.RegionConfig;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.internal.cache.AbstractRegion;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalCacheForClientAccess;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.partitioned.PRLocallyDestroyedException;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.management.cli.CliFunction;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.configuration.domain.DeclarableTypeInstantiator;
import org.apache.logging.log4j.Logger;

public class RegionAlterFunction
extends CliFunction<RegionConfig> {
    private static final Logger logger = LogService.getLogger();
    private static final long serialVersionUID = -4846425364943216425L;
    private static final String NULLSTR = "null";

    @Override
    public boolean isHA() {
        return false;
    }

    @Override
    public CliFunctionResult executeFunction(FunctionContext<RegionConfig> context) {
        InternalCacheForClientAccess cache = ((InternalCache)context.getCache()).getCacheForProcessingClientRequests();
        RegionConfig deltaConfig = context.getArguments();
        this.alterRegion(cache, deltaConfig);
        return new CliFunctionResult(context.getMemberName(), (Object)Result.Status.OK, String.format("Region %s altered", deltaConfig.getName()));
    }

    void alterRegion(Cache cache, RegionConfig deltaConfig) {
        DeclarableType declarableType;
        DeclarableType cacheLoader;
        List newCacheListeners;
        String regionPathString = deltaConfig.getName();
        AbstractRegion region = (AbstractRegion)cache.getRegion(regionPathString);
        if (region == null) {
            throw new IllegalArgumentException(String.format("Region does not exist: %s", regionPathString));
        }
        RegionAttributesType regionAttributes = deltaConfig.getRegionAttributes();
        AttributesMutator mutator = region.getAttributesMutator();
        if (regionAttributes.isCloningEnabled() != null) {
            mutator.setCloningEnabled(regionAttributes.isCloningEnabled());
            if (logger.isDebugEnabled()) {
                logger.debug("Region successfully altered - cloning");
            }
        }
        if (regionAttributes.getEvictionAttributes() != null) {
            mutator.getEvictionAttributesMutator().setMaximum(Integer.parseInt(regionAttributes.getEvictionAttributes().getLruEntryCount().getMaximum()));
            if (logger.isDebugEnabled()) {
                logger.debug("Region successfully altered - eviction attributes max");
            }
        }
        this.updateExpirationAttributes(cache, regionAttributes.getEntryIdleTime(), region.getEntryIdleTimeout(), p -> mutator.setEntryIdleTimeout((ExpirationAttributes)p), p -> mutator.setCustomEntryIdleTimeout(p));
        this.updateExpirationAttributes(cache, regionAttributes.getEntryTimeToLive(), region.getEntryTimeToLive(), p -> mutator.setEntryTimeToLive((ExpirationAttributes)p), p -> mutator.setCustomEntryTimeToLive(p));
        this.updateExpirationAttributes(cache, regionAttributes.getRegionIdleTime(), region.getRegionIdleTimeout(), p -> mutator.setRegionIdleTimeout((ExpirationAttributes)p), null);
        this.updateExpirationAttributes(cache, regionAttributes.getRegionTimeToLive(), region.getRegionTimeToLive(), p -> mutator.setRegionTimeToLive((ExpirationAttributes)p), null);
        Set newGatewaySenderIds = regionAttributes.getGatewaySenderIdsAsSet();
        Set newAsyncEventQueueIds = regionAttributes.getAsyncEventQueueIdsAsSet();
        if (region instanceof PartitionedRegion) {
            HashSet<String> senderIds = new HashSet<String>();
            if (newGatewaySenderIds != null) {
                this.validateParallelGatewaySenderIDs((PartitionedRegion)region, newGatewaySenderIds);
                senderIds.addAll(newGatewaySenderIds);
            } else if (region.getGatewaySenderIds() != null) {
                senderIds.addAll(region.getAllGatewaySenderIds());
            }
            if (newAsyncEventQueueIds != null) {
                this.validateParallelGatewaySenderIDs((PartitionedRegion)region, newAsyncEventQueueIds);
                senderIds.addAll(newAsyncEventQueueIds);
            } else if (region.getAsyncEventQueueIds() != null) {
                senderIds.addAll(region.getAsyncEventQueueIds());
            }
            ((PartitionedRegion)region).updatePRConfigWithNewSetOfAsynchronousEventDispatchers(senderIds);
        }
        if (newGatewaySenderIds != null) {
            Set<String> oldGatewaySenderIds = region.getGatewaySenderIds();
            if (!oldGatewaySenderIds.isEmpty()) {
                for (String string : oldGatewaySenderIds) {
                    if (newGatewaySenderIds.contains(string)) continue;
                    mutator.removeGatewaySenderId(string);
                }
            }
            for (String string : newGatewaySenderIds) {
                if (oldGatewaySenderIds.contains(string)) continue;
                mutator.addGatewaySenderId(string);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Region successfully altered - gateway sender IDs");
            }
        }
        if (newAsyncEventQueueIds != null) {
            Set<String> oldAsyncEventQueueIds = region.getAsyncEventQueueIds();
            if (!oldAsyncEventQueueIds.isEmpty()) {
                for (String string : oldAsyncEventQueueIds) {
                    if (newAsyncEventQueueIds.contains(string)) continue;
                    mutator.removeAsyncEventQueueId(string);
                }
            }
            for (String string : newAsyncEventQueueIds) {
                if (oldAsyncEventQueueIds.contains(string)) continue;
                mutator.addAsyncEventQueueId(string);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Region successfully altered - async event queue IDs");
            }
        }
        if (!(newCacheListeners = regionAttributes.getCacheListeners()).isEmpty()) {
            CacheListener[] oldCacheListeners;
            for (CacheListener oldCacheListener : oldCacheListeners = region.getCacheListeners()) {
                mutator.removeCacheListener(oldCacheListener);
            }
            for (DeclarableType newCacheListener : newCacheListeners) {
                if (newCacheListener.equals((Object)DeclarableType.EMPTY)) continue;
                mutator.addCacheListener((CacheListener)DeclarableTypeInstantiator.newInstance(newCacheListener, cache));
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Region successfully altered - cache listeners");
            }
        }
        if ((cacheLoader = regionAttributes.getCacheLoader()) != null) {
            if (cacheLoader.equals((Object)DeclarableType.EMPTY)) {
                mutator.setCacheLoader(null);
            } else {
                mutator.setCacheLoader((CacheLoader)DeclarableTypeInstantiator.newInstance(cacheLoader, cache));
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Region successfully altered - cache loader");
            }
        }
        if ((declarableType = regionAttributes.getCacheWriter()) != null) {
            if (declarableType.equals((Object)DeclarableType.EMPTY)) {
                mutator.setCacheWriter(null);
            } else {
                mutator.setCacheWriter((CacheWriter)DeclarableTypeInstantiator.newInstance(declarableType, cache));
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Region successfully altered - cache writer");
            }
        }
    }

    private void updateExpirationAttributes(Cache cache, RegionAttributesType.ExpirationAttributesType newAttributes, ExpirationAttributes existingAttributes, Consumer<ExpirationAttributes> mutator1, Consumer<CustomExpiry> mutator2) {
        if (newAttributes == null) {
            return;
        }
        if (newAttributes.hasTimoutOrAction() && existingAttributes != null) {
            int existingTimeout = existingAttributes.getTimeout();
            ExpirationAction existingAction = existingAttributes.getAction();
            if (newAttributes.getTimeout() != null) {
                existingTimeout = Integer.parseInt(newAttributes.getTimeout());
            }
            if (newAttributes.getAction() != null) {
                existingAction = ExpirationAction.fromXmlString((String)newAttributes.getAction());
            }
            mutator1.accept(new ExpirationAttributes(existingTimeout, existingAction));
        }
        if (mutator2 == null) {
            return;
        }
        if (newAttributes.hasCustomExpiry()) {
            DeclarableType newCustomExpiry = newAttributes.getCustomExpiry();
            if (newCustomExpiry.equals((Object)DeclarableType.EMPTY)) {
                mutator2.accept(null);
            } else {
                mutator2.accept((CustomExpiry)DeclarableTypeInstantiator.newInstance(newCustomExpiry, cache));
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Region successfully altered - entry idle timeout");
        }
    }

    private void validateParallelGatewaySenderIDs(PartitionedRegion region, Set<String> newGatewaySenderIds) {
        try {
            Set<String> parallelSenders = region.filterOutNonParallelGatewaySenders(newGatewaySenderIds);
            region.validateParallelGatewaySenderIds(parallelSenders);
        }
        catch (PRLocallyDestroyedException e) {
            throw new IllegalStateException("Partitioned Region not found registered", e);
        }
    }

    @Override
    public String getId() {
        return RegionAlterFunction.class.getName();
    }
}

