/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.asyncqueue.AsyncEventListener;
import org.apache.geode.cache.asyncqueue.AsyncEventQueue;
import org.apache.geode.cache.asyncqueue.internal.AsyncEventQueueImpl;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.cache.wan.AbstractGatewaySender;
import org.apache.geode.internal.cache.xmlcache.Declarable2;
import org.apache.geode.management.cli.CliFunction;
import org.apache.geode.management.internal.cli.domain.AsyncEventQueueDetails;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;

public class ListAsyncEventQueuesFunction
extends CliFunction {
    private static final long serialVersionUID = 1L;

    @Override
    public String getId() {
        return this.getClass().getName();
    }

    public CliFunctionResult executeFunction(FunctionContext context) {
        Cache cache = context.getCache();
        DistributedMember member = cache.getDistributedSystem().getDistributedMember();
        String memberId = !member.getName().equals("") ? member.getName() : member.getId();
        Set<AsyncEventQueue> asyncEventQueues = cache.getAsyncEventQueues();
        List details = asyncEventQueues.stream().map(queue -> {
            AsyncEventListener listener = queue.getAsyncEventListener();
            Properties listenerProperties = new Properties();
            if (listener instanceof Declarable2) {
                listenerProperties = ((Declarable2)((Object)listener)).getConfig();
            }
            return new AsyncEventQueueDetails(queue.getId(), queue.getBatchSize(), queue.isPersistent(), queue.getDiskStoreName(), queue.getMaximumQueueMemory(), listener.getClass().getName(), listenerProperties, this.isCreatedWithPausedEventDispatching((AsyncEventQueue)queue), queue.isDispatchingPaused());
        }).collect(Collectors.toList());
        return new CliFunctionResult(memberId, details);
    }

    private boolean isCreatedWithPausedEventDispatching(AsyncEventQueue queue) {
        return ((AbstractGatewaySender)((AsyncEventQueueImpl)queue).getSender()).isStartEventProcessorInPausedState();
    }
}

