/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import joptsimple.internal.Strings;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.execute.ResultSender;
import org.apache.geode.cache.wan.GatewayReceiver;
import org.apache.geode.cache.wan.GatewayReceiverFactory;
import org.apache.geode.cache.wan.GatewayTransportFilter;
import org.apache.geode.internal.ClassPathLoader;
import org.apache.geode.internal.cache.execute.InternalFunction;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.functions.GatewayReceiverFunctionArgs;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.logging.log4j.Logger;

public class GatewayReceiverCreateFunction
implements InternalFunction {
    public static final String A_GATEWAY_RECEIVER_ALREADY_EXISTS_ON_THIS_MEMBER = "A Gateway Receiver already exists on this member.";
    private static final Logger logger = LogService.getLogger();
    private static final long serialVersionUID = 8746830191680509335L;
    private static final String ID = GatewayReceiverCreateFunction.class.getName();
    @Immutable
    public static final GatewayReceiverCreateFunction INSTANCE = new GatewayReceiverCreateFunction();

    @Override
    public void execute(FunctionContext context) {
        ResultSender resultSender = context.getResultSender();
        Cache cache = context.getCache();
        String memberNameOrId = context.getMemberName();
        GatewayReceiverFunctionArgs gatewayReceiverCreateArgs = (GatewayReceiverFunctionArgs)context.getArguments();
        if (this.gatewayReceiverExists(cache)) {
            CliFunctionResult result;
            if (gatewayReceiverCreateArgs.getIfNotExists().booleanValue()) {
                result = new CliFunctionResult(memberNameOrId, CliFunctionResult.StatusState.OK, "Skipping: A Gateway Receiver already exists on this member.");
            } else {
                IllegalStateException illegalState = new IllegalStateException(A_GATEWAY_RECEIVER_ALREADY_EXISTS_ON_THIS_MEMBER);
                result = new CliFunctionResult(memberNameOrId, illegalState, illegalState.getMessage());
            }
            resultSender.lastResult(result);
            return;
        }
        try {
            GatewayReceiver createdGatewayReceiver = this.createGatewayReceiver(cache, gatewayReceiverCreateArgs);
            resultSender.lastResult(new CliFunctionResult(memberNameOrId, CliFunctionResult.StatusState.OK, CliStrings.format("GatewayReceiver created on member \"{0}\" and will listen on the port \"{1}\"", memberNameOrId, Integer.toString(createdGatewayReceiver.getPort()))));
        }
        catch (IllegalStateException e) {
            resultSender.lastResult(new CliFunctionResult(memberNameOrId, e, e.getMessage()));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            resultSender.lastResult(new CliFunctionResult(memberNameOrId, e, e.getMessage()));
        }
    }

    GatewayReceiver createGatewayReceiver(Cache cache, GatewayReceiverFunctionArgs gatewayReceiverCreateArgs) throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        String hostnameForSenders;
        String[] gatewayTransportFilters;
        Boolean manualStart;
        Integer socketBufferSize;
        Integer maxTimeBetweenPings;
        String bindAddress;
        Integer endPort;
        GatewayReceiverFactory gatewayReceiverFactory = cache.createGatewayReceiverFactory();
        Integer startPort = gatewayReceiverCreateArgs.getStartPort();
        if (startPort != null) {
            gatewayReceiverFactory.setStartPort(startPort);
        }
        if ((endPort = gatewayReceiverCreateArgs.getEndPort()) != null) {
            gatewayReceiverFactory.setEndPort(endPort);
        }
        if ((bindAddress = gatewayReceiverCreateArgs.getBindAddress()) != null) {
            gatewayReceiverFactory.setBindAddress(bindAddress);
        }
        if ((maxTimeBetweenPings = gatewayReceiverCreateArgs.getMaximumTimeBetweenPings()) != null) {
            gatewayReceiverFactory.setMaximumTimeBetweenPings(maxTimeBetweenPings);
        }
        if ((socketBufferSize = gatewayReceiverCreateArgs.getSocketBufferSize()) != null) {
            gatewayReceiverFactory.setSocketBufferSize(socketBufferSize);
        }
        if ((manualStart = gatewayReceiverCreateArgs.isManualStart()) != null) {
            gatewayReceiverFactory.setManualStart(manualStart);
        }
        if ((gatewayTransportFilters = gatewayReceiverCreateArgs.getGatewayTransportFilters()) != null) {
            for (String gatewayTransportFilter : gatewayTransportFilters) {
                gatewayReceiverFactory.addGatewayTransportFilter((GatewayTransportFilter)this.newInstance(gatewayTransportFilter));
            }
        }
        if ((hostnameForSenders = gatewayReceiverCreateArgs.getHostnameForSenders()) != null) {
            gatewayReceiverFactory.setHostnameForSenders(hostnameForSenders);
        }
        return gatewayReceiverFactory.create();
    }

    private Object newInstance(String className) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        if (Strings.isNullOrEmpty((String)className)) {
            return null;
        }
        return ClassPathLoader.getLatest().forName(className).newInstance();
    }

    boolean gatewayReceiverExists(Cache cache) {
        return cache.getGatewayReceivers() != null && !cache.getGatewayReceivers().isEmpty();
    }

    @Override
    public String getId() {
        return ID;
    }
}

