/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import java.util.HashMap;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.cache.execute.InternalFunction;
import org.apache.geode.management.internal.cli.util.BytesToString;

public class GarbageCollectionFunction
implements InternalFunction {
    public static final String ID = GarbageCollectionFunction.class.getName();
    private static final long serialVersionUID = 1L;

    @Override
    public void execute(FunctionContext context) {
        BytesToString bytesToString = new BytesToString();
        HashMap<String, String> resultMap = null;
        try {
            Cache cache = context.getCache();
            DistributedMember member = cache.getDistributedSystem().getDistributedMember();
            long freeMemoryBeforeGC = Runtime.getRuntime().freeMemory();
            long totalMemoryBeforeGC = Runtime.getRuntime().totalMemory();
            long timeBeforeGC = System.currentTimeMillis();
            Runtime.getRuntime().gc();
            long freeMemoryAfterGC = Runtime.getRuntime().freeMemory();
            long totalMemoryAfterGC = Runtime.getRuntime().totalMemory();
            long timeAfterGC = System.currentTimeMillis();
            resultMap = new HashMap<String, String>();
            resultMap.put("MemberId", member.getId());
            resultMap.put("HeapSizeBeforeGC", bytesToString.of(totalMemoryBeforeGC - freeMemoryBeforeGC));
            resultMap.put("HeapSizeAfterGC", bytesToString.of(totalMemoryAfterGC - freeMemoryAfterGC));
            resultMap.put("TimeSpentInGC", String.valueOf(timeAfterGC - timeBeforeGC));
        }
        catch (Exception ex) {
            String message = "Exception in GC:" + ex.getMessage() + ExceptionUtils.getStackTrace((Throwable)ex);
            context.getResultSender().lastResult(message);
        }
        context.getResultSender().lastResult(resultMap);
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public boolean isHA() {
        return false;
    }
}

