/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import java.util.Collection;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.configuration.RegionConfig;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.query.Index;
import org.apache.geode.cache.query.QueryService;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalCacheForClientAccess;
import org.apache.geode.management.cli.CliFunction;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.i18n.CliStrings;

public class DestroyIndexFunction
extends CliFunction {
    private static final long serialVersionUID = -868082551095130315L;

    public CliFunctionResult executeFunction(FunctionContext context) {
        CliFunctionResult result;
        RegionConfig.Index indexInfo = (RegionConfig.Index)context.getArguments();
        String memberId = null;
        try {
            InternalCacheForClientAccess cache = ((InternalCache)context.getCache()).getCacheForProcessingClientRequests();
            memberId = cache.getDistributedSystem().getDistributedMember().getId();
            QueryService queryService = cache.getQueryService();
            String indexName = indexInfo.getName();
            String regionPath = indexInfo.getFromClause();
            if (regionPath != null && !regionPath.isEmpty()) {
                Region region = cache.getRegion(regionPath);
                if (region != null) {
                    if (indexName == null || indexName.isEmpty()) {
                        queryService.removeIndexes(region);
                        result = new CliFunctionResult(memberId, CliFunctionResult.StatusState.OK, "Destroyed all indexes on region " + regionPath);
                    } else {
                        Index index = queryService.getIndex(region, indexName);
                        if (index != null) {
                            queryService.removeIndex(index);
                            result = new CliFunctionResult(memberId, CliFunctionResult.StatusState.OK, "Destroyed index " + indexName + " on region " + regionPath);
                        } else {
                            result = new CliFunctionResult(memberId, CliFunctionResult.StatusState.IGNORABLE, CliStrings.format("Index named \"{0}\" not found", (Object)indexName));
                        }
                    }
                } else {
                    result = new CliFunctionResult(memberId, CliFunctionResult.StatusState.ERROR, CliStrings.format("Region \"{0}\" not found", (Object)regionPath));
                }
            } else if (indexName == null || indexName.isEmpty()) {
                queryService.removeIndexes();
                result = new CliFunctionResult(memberId, CliFunctionResult.StatusState.OK, "Destroyed all indexes");
            } else {
                boolean indexRemoved = this.removeIndexByName(indexName, queryService);
                result = indexRemoved ? new CliFunctionResult(memberId, CliFunctionResult.StatusState.OK, "Destroyed index " + indexName) : new CliFunctionResult(memberId, CliFunctionResult.StatusState.IGNORABLE, CliStrings.format("Index named \"{0}\" not found", (Object)indexName));
            }
        }
        catch (CacheClosedException e) {
            result = new CliFunctionResult(memberId, e, e.getMessage());
        }
        catch (Exception e) {
            result = new CliFunctionResult(memberId, e, e.getMessage());
        }
        return result;
    }

    private boolean removeIndexByName(String name, QueryService queryService) {
        boolean removed = false;
        Collection<Index> indexes = queryService.getIndexes();
        for (Index index : indexes) {
            if (!index.getName().equals(name)) continue;
            queryService.removeIndex(index);
            removed = true;
        }
        return removed;
    }

    @Override
    public String getId() {
        return DestroyIndexFunction.class.getName();
    }
}

