/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.management.ObjectName;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.management.CacheServerMXBean;
import org.apache.geode.management.DistributedRegionMXBean;
import org.apache.geode.management.DistributedSystemMXBean;
import org.apache.geode.management.JVMMetrics;
import org.apache.geode.management.ManagementService;
import org.apache.geode.management.MemberMXBean;
import org.apache.geode.management.RegionMXBean;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.GfshCommand;
import org.apache.geode.management.internal.MBeanJMXAdapter;
import org.apache.geode.management.internal.SystemManagementService;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.result.ResultDataException;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.cli.result.model.TabularResultModel;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class ShowMetricsCommand
extends GfshCommand {
    @Immutable
    static final List<Category> REGION_METRIC_CATEGORIES = Collections.unmodifiableList(Arrays.asList(Category.callback, Category.diskstore, Category.eviction, Category.partition, Category.region));
    @Immutable
    static final List<Category> SYSTEM_METRIC_CATEGORIES = Collections.unmodifiableList(Arrays.asList(Category.cache, Category.cluster, Category.diskstore, Category.query));
    @Immutable
    static final List<Category> SYSTEM_REGION_METRIC_CATEGORIES = Collections.unmodifiableList(Arrays.asList(Category.callback, Category.cluster, Category.diskstore, Category.eviction, Category.partition, Category.region));
    @Immutable
    static final List<Category> MEMBER_METRIC_CATEGORIES = Collections.unmodifiableList(Arrays.asList(Category.communication, Category.diskstore, Category.distribution, Category.eviction, Category.function, Category.jvm, Category.lock, Category.member, Category.offheap, Category.region, Category.serialization, Category.transaction));
    @Immutable
    static final List<Category> MEMBER_WITH_PORT_METRIC_CATEGORIES = Collections.unmodifiableList(Arrays.asList(Category.cacheserver, Category.communication, Category.diskstore, Category.distribution, Category.eviction, Category.function, Category.jvm, Category.lock, Category.member, Category.notification, Category.offheap, Category.query, Category.region, Category.serialization, Category.transaction));

    @CliCommand(value={"show metrics"}, help="Display or export metrics for the entire distributed system, a member or a region.")
    @CliMetaData(relatedTopic={"Statistics"}, interceptor="org.apache.geode.management.internal.cli.commands.ShowMetricsInterceptor")
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.READ)
    public ResultModel showMetrics(@CliOption(key={"member"}, optionContext="geode.converter.all.member.idOrName:disable-string-converter", help="Name/Id of the member whose metrics will be displayed/exported.") String memberNameOrId, @CliOption(key={"region"}, optionContext="geode.converter.region.path:disable-string-converter", help="Name/Path of the region whose metrics will be displayed/exported.") String regionName, @CliOption(key={"file"}, help="Name of the file to which metrics will be written.") String export_to_report_to, @CliOption(key={"port"}, help="Port number of the Cache Server whose metrics are to be displayed/exported. This can only be used along with the --member parameter.") Integer rawCacheServerPort, @CliOption(key={"categories"}, help="Categories available based upon the parameters specified are:\n- no parameters specified: cluster, cache, diskstore, query\n- region specified: callback, cluster, diskstore, eviction, partition, region\n- member specified: communication, diskstore, distribution, eviction, function, jvm, lock, member, offheap, region, serialization, transaction\n- member and port specified: cacheserver, communication, diskstore, distribution, eviction, function, jvm, lock, member, notification, offheap, query, region, serialization, transaction\n- member and region specified: callback, diskstore, eviction, partition, region") String[] categories) {
        ResultModel result;
        StringBuilder csvBuilder;
        DistributedMember member = memberNameOrId == null ? null : this.getMember(memberNameOrId);
        StringBuilder stringBuilder = csvBuilder = StringUtils.isEmpty((CharSequence)export_to_report_to) ? null : this.prepareCsvBuilder();
        if (regionName != null && memberNameOrId != null) {
            result = this.getRegionMetricsFromMember(regionName, member, export_to_report_to, categories, csvBuilder);
        } else if (regionName != null) {
            result = this.getDistributedRegionMetrics(regionName, export_to_report_to, categories, csvBuilder);
        } else if (memberNameOrId != null) {
            int cacheServerPort = rawCacheServerPort == null ? -1 : rawCacheServerPort;
            result = this.getMemberMetrics(member, export_to_report_to, categories, cacheServerPort, csvBuilder);
        } else {
            result = this.getSystemWideMetrics(export_to_report_to, categories, csvBuilder);
        }
        return result;
    }

    private ResultModel getSystemWideMetrics(String export_to_report_to, String[] categoriesArr, StringBuilder csvBuilder) {
        Object managementService = this.getManagementService();
        DistributedSystemMXBean dsMxBean = ((ManagementService)managementService).getDistributedSystemMXBean();
        if (dsMxBean == null) {
            String errorMessage = CliStrings.format("Unable to retrieve metrics : {0} ", (Object)"Distributed System MBean not found");
            return ResultModel.createError(errorMessage);
        }
        ResultModel result = new ResultModel();
        TabularResultModel metricsTable = result.addTable("cluster-metrics");
        Set<Category> categoriesToDisplay = ArrayUtils.isNotEmpty((Object[])categoriesArr) ? this.getCategorySet(categoriesArr) : new HashSet<Category>(SYSTEM_METRIC_CATEGORIES);
        metricsTable.setHeader("Cluster-wide Metrics");
        this.writeSystemWideMetricValues(dsMxBean, csvBuilder, metricsTable, categoriesToDisplay);
        if (StringUtils.isNotEmpty((CharSequence)export_to_report_to)) {
            result.addFile(export_to_report_to, csvBuilder.toString());
        }
        return result;
    }

    private ResultModel getMemberMetrics(DistributedMember distributedMember, String export_to_report_to, String[] categoriesArr, int cacheServerPort, StringBuilder csvBuilder) throws ResultDataException {
        ObjectName csMxBeanName;
        SystemManagementService managementService = (SystemManagementService)this.getManagementService();
        ObjectName memberMBeanName = managementService.getMemberMBeanName(distributedMember);
        MemberMXBean memberMxBean = managementService.getMBeanInstance(memberMBeanName, MemberMXBean.class);
        CacheServerMXBean csMxBean = null;
        if (memberMxBean == null) {
            String errorMessage = CliStrings.format("Unable to retrieve metrics : {0} ", (Object)("Member MBean for " + MBeanJMXAdapter.getMemberNameOrUniqueId(distributedMember) + " not found"));
            return ResultModel.createError(errorMessage);
        }
        if (cacheServerPort != -1 && (csMxBean = managementService.getMBeanInstance(csMxBeanName = managementService.getCacheServerMBeanName(cacheServerPort, distributedMember), CacheServerMXBean.class)) == null) {
            return ResultModel.createError(CliStrings.format("Metrics for the Cache Server with port : {0} and member : {1} not found.\n Please check the port number and the member name/id", cacheServerPort, MBeanJMXAdapter.getMemberNameOrUniqueId(distributedMember)));
        }
        JVMMetrics jvmMetrics = memberMxBean.showJVMMetrics();
        ResultModel result = new ResultModel();
        TabularResultModel metricsTable = result.addTable("member-metrics");
        metricsTable.setHeader("Member Metrics");
        List<Category> fullCategories = csMxBean != null ? MEMBER_WITH_PORT_METRIC_CATEGORIES : MEMBER_METRIC_CATEGORIES;
        Set<Category> categoriesToDisplay = ArrayUtils.isNotEmpty((Object[])categoriesArr) ? this.getCategorySet(categoriesArr) : new HashSet<Category>(fullCategories);
        this.writeMemberMetricValues(memberMxBean, jvmMetrics, metricsTable, csvBuilder, categoriesToDisplay);
        if (csMxBean != null) {
            this.writeCacheServerMetricValues(csMxBean, metricsTable, csvBuilder, categoriesToDisplay);
        }
        if (StringUtils.isNotEmpty((CharSequence)export_to_report_to)) {
            result.addFile(export_to_report_to, csvBuilder != null ? csvBuilder.toString() : null);
        }
        return result;
    }

    private ResultModel getDistributedRegionMetrics(String regionName, String export_to_report_to, String[] categoriesArr, StringBuilder csvBuilder) throws ResultDataException {
        Object managementService = this.getManagementService();
        DistributedRegionMXBean regionMxBean = ((ManagementService)managementService).getDistributedRegionMXBean(regionName);
        if (regionMxBean == null) {
            String errorMessage = CliStrings.format("Unable to retrieve metrics : {0} ", (Object)("Distributed Region MBean for " + regionName + " not found"));
            return ResultModel.createError(errorMessage);
        }
        ResultModel result = new ResultModel();
        TabularResultModel metricsTable = result.addTable("metrics");
        metricsTable.setHeader("Cluster-wide Region Metrics");
        Set<Category> categoriesToDisplay = ArrayUtils.isNotEmpty((Object[])categoriesArr) ? this.getCategorySet(categoriesArr) : new HashSet<Category>(SYSTEM_REGION_METRIC_CATEGORIES);
        this.writeSystemRegionMetricValues(regionMxBean, metricsTable, csvBuilder, categoriesToDisplay);
        if (StringUtils.isNotEmpty((CharSequence)export_to_report_to)) {
            result.addFile(export_to_report_to, csvBuilder != null ? csvBuilder.toString() : null);
        }
        return result;
    }

    private ResultModel getRegionMetricsFromMember(String regionName, DistributedMember distributedMember, String export_to_report_to, String[] categoriesArr, StringBuilder csvBuilder) throws ResultDataException {
        ObjectName regionMBeanName;
        SystemManagementService managementService = (SystemManagementService)this.getManagementService();
        RegionMXBean regionMxBean = managementService.getMBeanInstance(regionMBeanName = managementService.getRegionMBeanName(distributedMember, regionName), RegionMXBean.class);
        if (regionMxBean == null) {
            String errorMessage = CliStrings.format("Unable to retrieve metrics : {0} ", (Object)("Region MBean for " + regionName + " on member " + MBeanJMXAdapter.getMemberNameOrUniqueId(distributedMember) + " not found"));
            return ResultModel.createError(errorMessage);
        }
        ResultModel result = new ResultModel();
        TabularResultModel metricsTable = result.addTable("metrics");
        metricsTable.setHeader("Metrics for region:" + regionName + " On Member " + MBeanJMXAdapter.getMemberNameOrUniqueId(distributedMember));
        Set<Category> categoriesToDisplay = ArrayUtils.isNotEmpty((Object[])categoriesArr) ? this.getCategorySet(categoriesArr) : new HashSet<Category>(REGION_METRIC_CATEGORIES);
        this.writeRegionMetricValues(regionMxBean, metricsTable, csvBuilder, categoriesToDisplay);
        if (StringUtils.isNotEmpty((CharSequence)export_to_report_to)) {
            result.addFile(export_to_report_to, csvBuilder != null ? csvBuilder.toString() : null);
        }
        return result;
    }

    private void writeSystemWideMetricValues(DistributedSystemMXBean dsMxBean, StringBuilder csvBuilder, TabularResultModel metricsTable, Set<Category> categoriesToDisplay) {
        if (categoriesToDisplay.contains((Object)Category.cluster)) {
            this.writeToTableAndCsv(metricsTable, "cluster", "totalHeapSize", dsMxBean.getTotalHeapSize(), csvBuilder);
        }
        if (categoriesToDisplay.contains((Object)Category.cache)) {
            this.writeToTableAndCsv(metricsTable, "cache", "totalRegionEntryCount", dsMxBean.getTotalRegionEntryCount(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "totalRegionCount", dsMxBean.getTotalRegionCount(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "totalMissCount", dsMxBean.getTotalMissCount(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "totalHitCount", dsMxBean.getTotalHitCount(), csvBuilder);
        }
        if (categoriesToDisplay.contains((Object)Category.diskstore)) {
            this.writeToTableAndCsv(metricsTable, "diskstore", "totalDiskUsage", dsMxBean.getTotalDiskUsage(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "diskReadsRate", dsMxBean.getDiskReadsRate(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "diskWritesRate", dsMxBean.getDiskWritesRate(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "flushTimeAvgLatency", dsMxBean.getDiskFlushAvgLatency(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "totalBackupInProgress", dsMxBean.getTotalBackupInProgress(), csvBuilder);
        }
        if (categoriesToDisplay.contains((Object)Category.query)) {
            this.writeToTableAndCsv(metricsTable, "query", "activeCQCount", dsMxBean.getActiveCQCount(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "queryRequestRate", dsMxBean.getQueryRequestRate(), csvBuilder);
        }
    }

    private void writeMemberMetricValues(MemberMXBean memberMxBean, JVMMetrics jvmMetrics, TabularResultModel metricsTable, StringBuilder csvBuilder, Set<Category> categoriesToDisplay) {
        if (categoriesToDisplay.contains((Object)Category.member)) {
            this.writeToTableAndCsv(metricsTable, "member", "upTime", memberMxBean.getMemberUpTime(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "cpuUsage", memberMxBean.getCpuUsage(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "currentHeapSize", memberMxBean.getCurrentHeapSize(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "maximumHeapSize", memberMxBean.getMaximumHeapSize(), csvBuilder);
        }
        if (categoriesToDisplay.contains((Object)Category.jvm)) {
            this.writeToTableAndCsv(metricsTable, "jvm", "jvmThreads ", jvmMetrics.getTotalThreads(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "fileDescriptorLimit", memberMxBean.getFileDescriptorLimit(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "totalFileDescriptorOpen", memberMxBean.getTotalFileDescriptorOpen(), csvBuilder);
        }
        if (categoriesToDisplay.contains((Object)Category.region)) {
            this.writeToTableAndCsv(metricsTable, "region", "totalRegionCount ", memberMxBean.getTotalRegionCount(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "listOfRegions", (String[])Arrays.stream(memberMxBean.listRegions()).map(s -> s.substring(1)).toArray(String[]::new), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "rootRegions", memberMxBean.getRootRegionNames(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "totalRegionEntryCount", memberMxBean.getTotalRegionEntryCount(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "totalBucketCount", memberMxBean.getTotalBucketCount(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "totalPrimaryBucketCount", memberMxBean.getTotalPrimaryBucketCount(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "getsAvgLatency", memberMxBean.getGetsAvgLatency(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "putsAvgLatency", memberMxBean.getPutsAvgLatency(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "createsRate", memberMxBean.getCreatesRate(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "destroyRate", memberMxBean.getDestroysRate(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "putAllAvgLatency", memberMxBean.getPutAllAvgLatency(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "totalMissCount", memberMxBean.getTotalMissCount(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "totalHitCount", memberMxBean.getTotalHitCount(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "getsRate", memberMxBean.getGetsRate(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "putsRate", memberMxBean.getPutsRate(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "cacheWriterCallsAvgLatency", memberMxBean.getCacheWriterCallsAvgLatency(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "cacheListenerCallsAvgLatency", memberMxBean.getCacheListenerCallsAvgLatency(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "totalLoadsCompleted", memberMxBean.getTotalLoadsCompleted(), csvBuilder);
        }
        if (categoriesToDisplay.contains((Object)Category.serialization)) {
            this.writeToTableAndCsv(metricsTable, "serialization", "serializationRate", memberMxBean.getSerializationRate(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "serializationLatency", memberMxBean.getSerializationRate(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "deserializationRate", memberMxBean.getDeserializationRate(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "deserializationLatency", memberMxBean.getDeserializationLatency(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "deserializationAvgLatency", memberMxBean.getDeserializationAvgLatency(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "PDXDeserializationAvgLatency", memberMxBean.getPDXDeserializationAvgLatency(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "PDXDeserializationRate", memberMxBean.getPDXDeserializationRate(), csvBuilder);
        }
        if (categoriesToDisplay.contains((Object)Category.communication)) {
            this.writeToTableAndCsv(metricsTable, "communication", "bytesSentRate", memberMxBean.getBytesSentRate(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "bytesReceivedRate", memberMxBean.getBytesReceivedRate(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "connectedGatewayReceivers", memberMxBean.listConnectedGatewayReceivers(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "connectedGatewaySenders", memberMxBean.listConnectedGatewaySenders(), csvBuilder);
        }
        if (categoriesToDisplay.contains((Object)Category.function)) {
            this.writeToTableAndCsv(metricsTable, "function", "numRunningFunctions", memberMxBean.getNumRunningFunctions(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "functionExecutionRate", memberMxBean.getFunctionExecutionRate(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "numRunningFunctionsHavingResults", memberMxBean.getNumRunningFunctionsHavingResults(), csvBuilder);
        }
        if (categoriesToDisplay.contains((Object)Category.transaction)) {
            this.writeToTableAndCsv(metricsTable, "transaction", "totalTransactionsCount", memberMxBean.getTotalTransactionsCount(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "transactionCommitsAvgLatency", memberMxBean.getTransactionCommitsAvgLatency(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "transactionCommittedTotalCount", memberMxBean.getTransactionCommittedTotalCount(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "transactionRolledBackTotalCount", memberMxBean.getTransactionRolledBackTotalCount(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "transactionCommitsRate", memberMxBean.getTransactionCommitsRate(), csvBuilder);
        }
        if (categoriesToDisplay.contains((Object)Category.diskstore)) {
            this.writeToTableAndCsv(metricsTable, "diskstore", "totalDiskUsage", memberMxBean.getTotalDiskUsage(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "diskReadsRate", memberMxBean.getDiskReadsRate(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "diskWritesRate", memberMxBean.getDiskWritesRate(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "flushTimeAvgLatency", memberMxBean.getDiskFlushAvgLatency(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "totalQueueSize", memberMxBean.getTotalDiskTasksWaiting(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "totalBackupInProgress", memberMxBean.getTotalBackupInProgress(), csvBuilder);
        }
        if (categoriesToDisplay.contains((Object)Category.lock)) {
            this.writeToTableAndCsv(metricsTable, "lock", "lockWaitsInProgress", memberMxBean.getLockWaitsInProgress(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "totalLockWaitTime", memberMxBean.getTotalLockWaitTime(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "totalNumberOfLockService", memberMxBean.getTotalNumberOfLockService(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "requestQueues", memberMxBean.getLockRequestQueues(), csvBuilder);
        }
        if (categoriesToDisplay.contains((Object)Category.eviction)) {
            this.writeToTableAndCsv(metricsTable, "eviction", "lruEvictionRate", memberMxBean.getLruEvictionRate(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "lruDestroyRate", memberMxBean.getLruDestroyRate(), csvBuilder);
        }
        if (categoriesToDisplay.contains((Object)Category.distribution)) {
            this.writeToTableAndCsv(metricsTable, "distribution", "getInitialImagesInProgress", memberMxBean.getInitialImagesInProgress(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "getInitialImageTime", memberMxBean.getInitialImageTime(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "getInitialImageKeysReceived", memberMxBean.getInitialImageKeysReceived(), csvBuilder);
        }
        if (categoriesToDisplay.contains((Object)Category.offheap)) {
            this.writeToTableAndCsv(metricsTable, "offheap", "maxMemory", memberMxBean.getOffHeapMaxMemory(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "freeMemory", memberMxBean.getOffHeapFreeMemory(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "usedMemory", memberMxBean.getOffHeapUsedMemory(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "objects", memberMxBean.getOffHeapObjects(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "fragmentation", memberMxBean.getOffHeapFragmentation(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "compactionTime", memberMxBean.getOffHeapCompactionTime(), csvBuilder);
        }
    }

    private void writeCacheServerMetricValues(CacheServerMXBean csMxBean, TabularResultModel metricsTable, StringBuilder csvBuilder, Set<Category> categoriesToDisplay) {
        if (categoriesToDisplay.contains((Object)Category.cacheserver)) {
            this.writeToTableAndCsv(metricsTable, "cacheserver", "clientConnectionCount", csMxBean.getClientConnectionCount(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "hostnameForClients", csMxBean.getHostNameForClients(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "getRequestAvgLatency", csMxBean.getGetRequestAvgLatency(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "putRequestAvgLatency", csMxBean.getPutRequestAvgLatency(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "totalConnectionsTimedOut", csMxBean.getTotalConnectionsTimedOut(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "threadQueueSize", csMxBean.getPutRequestAvgLatency(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "connectionThreads", csMxBean.getConnectionThreads(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "connectionLoad", csMxBean.getConnectionLoad(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "loadPerConnection", csMxBean.getLoadPerConnection(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "queueLoad", csMxBean.getQueueLoad(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "loadPerQueue", csMxBean.getLoadPerQueue(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "getRequestRate", csMxBean.getGetRequestRate(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "putRequestRate", csMxBean.getPutRequestRate(), csvBuilder);
        }
        if (categoriesToDisplay.contains((Object)Category.notification)) {
            this.writeToTableAndCsv(metricsTable, "notification", "numClientNotificationRequests", csMxBean.getNumClientNotificationRequests(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "clientNotificationRate", csMxBean.getClientNotificationRate(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "clientNotificationAvgLatency", csMxBean.getClientNotificationAvgLatency(), csvBuilder);
        }
        if (categoriesToDisplay.contains((Object)Category.query)) {
            this.writeToTableAndCsv(metricsTable, "query", "activeCQCount", csMxBean.getActiveCQCount(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "queryRequestRate", csMxBean.getQueryRequestRate(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "indexCount", csMxBean.getIndexCount(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "index list", csMxBean.getIndexList(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "totalIndexMaintenanceTime", csMxBean.getTotalIndexMaintenanceTime(), csvBuilder);
        }
    }

    private void writeSystemRegionMetricValues(DistributedRegionMXBean regionMxBean, TabularResultModel metricsTable, StringBuilder csvBuilder, Set<Category> categoriesToDisplay) {
        if (categoriesToDisplay.contains((Object)Category.cluster)) {
            this.writeToTableAndCsv(metricsTable, "cluster", "member count", regionMxBean.getMemberCount(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "region entry count", regionMxBean.getSystemRegionEntryCount(), csvBuilder);
        }
        if (categoriesToDisplay.contains((Object)Category.region)) {
            this.writeToTableAndCsv(metricsTable, "region", "lastModifiedTime", regionMxBean.getLastModifiedTime(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "lastAccessedTime", regionMxBean.getLastAccessedTime(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "missCount", regionMxBean.getMissCount(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "hitCount", regionMxBean.getHitCount(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "hitRatio", regionMxBean.getHitRatio(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "getsRate", regionMxBean.getGetsRate(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "putsRate", regionMxBean.getPutsRate(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "createsRate", regionMxBean.getCreatesRate(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "destroyRate", regionMxBean.getDestroyRate(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "putAllRate", regionMxBean.getPutAllRate(), csvBuilder);
        }
        if (categoriesToDisplay.contains((Object)Category.partition)) {
            this.writeToTableAndCsv(metricsTable, "partition", "putLocalRate", regionMxBean.getPutLocalRate(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "putRemoteRate", regionMxBean.getPutRemoteRate(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "putRemoteLatency", regionMxBean.getPutRemoteLatency(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "putRemoteAvgLatency", regionMxBean.getPutRemoteAvgLatency(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "bucketCount", regionMxBean.getBucketCount(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "primaryBucketCount", regionMxBean.getPrimaryBucketCount(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "numBucketsWithoutRedundancy", regionMxBean.getNumBucketsWithoutRedundancy(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "totalBucketSize", regionMxBean.getTotalBucketSize(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "averageBucketSize", regionMxBean.getAvgBucketSize(), csvBuilder);
        }
        if (categoriesToDisplay.contains((Object)Category.diskstore)) {
            this.writeToTableAndCsv(metricsTable, "diskstore", "totalEntriesOnlyOnDisk", regionMxBean.getTotalEntriesOnlyOnDisk(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "diskReadsRate", regionMxBean.getDiskReadsRate(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "diskWritesRate", regionMxBean.getDiskWritesRate(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "totalDiskWriteInProgress", regionMxBean.getTotalDiskWritesProgress(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "diskTaskWaiting", regionMxBean.getDiskTaskWaiting(), csvBuilder);
        }
        if (categoriesToDisplay.contains((Object)Category.callback)) {
            this.writeToTableAndCsv(metricsTable, "callback", "cacheWriterCallsAvgLatency", regionMxBean.getCacheWriterCallsAvgLatency(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "cacheListenerCallsAvgLatency", regionMxBean.getCacheListenerCallsAvgLatency(), csvBuilder);
        }
        if (categoriesToDisplay.contains((Object)Category.eviction)) {
            this.writeToTableAndCsv(metricsTable, "eviction", "lruEvictionRate", regionMxBean.getLruEvictionRate(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "lruDestroyRate", regionMxBean.getLruDestroyRate(), csvBuilder);
        }
    }

    private void writeRegionMetricValues(RegionMXBean regionMxBean, TabularResultModel metricsTable, StringBuilder csvBuilder, Set<Category> categoriesToDisplay) {
        if (categoriesToDisplay.contains((Object)Category.region)) {
            this.writeToTableAndCsv(metricsTable, "region", "lastModifiedTime", regionMxBean.getLastModifiedTime(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "lastAccessedTime", regionMxBean.getLastAccessedTime(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "missCount", regionMxBean.getMissCount(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "hitCount", regionMxBean.getHitCount(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "hitRatio", regionMxBean.getHitRatio(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "getsRate", regionMxBean.getGetsRate(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "putsRate", regionMxBean.getPutsRate(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "createsRate", regionMxBean.getCreatesRate(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "destroyRate", regionMxBean.getDestroyRate(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "putAllRate", regionMxBean.getPutAllRate(), csvBuilder);
        }
        if (categoriesToDisplay.contains((Object)Category.partition)) {
            this.writeToTableAndCsv(metricsTable, "partition", "putLocalRate", regionMxBean.getPutLocalRate(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "putRemoteRate", regionMxBean.getPutRemoteRate(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "putRemoteLatency", regionMxBean.getPutRemoteLatency(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "putRemoteAvgLatency", regionMxBean.getPutRemoteAvgLatency(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "bucketCount", regionMxBean.getBucketCount(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "primaryBucketCount", regionMxBean.getPrimaryBucketCount(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "configuredRedundancy", regionMxBean.getConfiguredRedundancy(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "actualRedundancy", regionMxBean.getActualRedundancy(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "numBucketsWithoutRedundancy", regionMxBean.getNumBucketsWithoutRedundancy(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "totalBucketSize", regionMxBean.getTotalBucketSize(), csvBuilder);
        }
        if (categoriesToDisplay.contains((Object)Category.diskstore)) {
            this.writeToTableAndCsv(metricsTable, "diskstore", "totalEntriesOnlyOnDisk", regionMxBean.getTotalEntriesOnlyOnDisk(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "diskReadsRate", "" + regionMxBean.getDiskReadsRate(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "diskWritesRate", regionMxBean.getDiskWritesRate(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "totalDiskWriteInProgress", regionMxBean.getTotalDiskWritesProgress(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "diskTaskWaiting", regionMxBean.getDiskTaskWaiting(), csvBuilder);
        }
        if (categoriesToDisplay.contains((Object)Category.callback)) {
            this.writeToTableAndCsv(metricsTable, "callback", "cacheWriterCallsAvgLatency", regionMxBean.getCacheWriterCallsAvgLatency(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "cacheListenerCallsAvgLatency", regionMxBean.getCacheListenerCallsAvgLatency(), csvBuilder);
        }
        if (categoriesToDisplay.contains((Object)Category.eviction)) {
            this.writeToTableAndCsv(metricsTable, "eviction", "lruEvictionRate", regionMxBean.getLruEvictionRate(), csvBuilder);
            this.writeToTableAndCsv(metricsTable, "", "lruDestroyRate", regionMxBean.getLruDestroyRate(), csvBuilder);
        }
    }

    private void writeToTableAndCsv(TabularResultModel metricsTable, String type, String metricName, String metricValue, StringBuilder csvBuilder) {
        metricsTable.accumulate("Category", type);
        metricsTable.accumulate("Metric", metricName);
        metricsTable.accumulate("Value", metricValue);
        this.writeToCsvIfNecessary(type, metricName, String.valueOf(metricValue), csvBuilder);
    }

    private void writeToTableAndCsv(TabularResultModel metricsTable, String type, String metricName, String[] metricValue, StringBuilder csvBuilder) {
        if (ArrayUtils.isEmpty((Object[])metricValue)) {
            return;
        }
        for (int i = 0; i < metricValue.length; ++i) {
            if (i == 0) {
                this.writeToTableAndCsv(metricsTable, type, metricName, metricValue[i], csvBuilder);
                continue;
            }
            this.writeToTableAndCsv(metricsTable, "", "", metricValue[i], csvBuilder);
        }
    }

    private void writeToTableAndCsv(TabularResultModel metricsTable, String type, String metricName, long metricValue, StringBuilder csvBuilder) {
        this.writeToTableAndCsv(metricsTable, type, metricName, String.valueOf(metricValue), csvBuilder);
    }

    private void writeToTableAndCsv(TabularResultModel metricsTable, String type, String metricName, double metricValue, StringBuilder csvBuilder) {
        this.writeToTableAndCsv(metricsTable, type, metricName, String.valueOf(metricValue), csvBuilder);
    }

    private StringBuilder prepareCsvBuilder() {
        StringBuilder csvBuilder = new StringBuilder();
        csvBuilder.append("Category");
        csvBuilder.append(',');
        csvBuilder.append("Metric");
        csvBuilder.append(',');
        csvBuilder.append("Value");
        csvBuilder.append('\n');
        return csvBuilder;
    }

    private void writeToCsvIfNecessary(String type, String metricName, String metricValue, StringBuilder csvBuilder) {
        if (csvBuilder != null) {
            csvBuilder.append(type);
            csvBuilder.append(',');
            csvBuilder.append(metricName);
            csvBuilder.append(',');
            csvBuilder.append(metricValue);
            csvBuilder.append('\n');
        }
    }

    private Set<Category> getCategorySet(String[] categories) {
        return Stream.of(categories).map(String::toLowerCase).map(Category::valueOf).collect(Collectors.toSet());
    }

    static enum Category {
        cache,
        cacheserver,
        callback,
        cluster,
        communication,
        diskstore,
        distribution,
        eviction,
        function,
        jvm,
        lock,
        offheap,
        member,
        notification,
        partition,
        query,
        region,
        serialization,
        transaction;

    }
}

