/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.io.IOException;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.deadlock.DeadlockDetector;
import org.apache.geode.distributed.internal.deadlock.Dependency;
import org.apache.geode.distributed.internal.deadlock.DependencyGraph;
import org.apache.geode.distributed.internal.deadlock.GemFireDeadlockDetector;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.GfshCommand;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.CliAroundInterceptor;
import org.apache.geode.management.internal.cli.GfshParseResult;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.result.model.FileResultModel;
import org.apache.geode.management.internal.cli.result.model.InfoResultModel;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class ShowDeadlockCommand
extends GfshCommand {
    @CliCommand(value={"show dead-locks"}, help="Display any deadlocks in the Geode distributed system.")
    @CliMetaData(relatedTopic={"Debug-Utility"}, interceptor="org.apache.geode.management.internal.cli.commands.ShowDeadlockCommand$Interceptor")
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.READ)
    public ResultModel showDeadlock(@CliOption(key={"file"}, help="Name of the file to which dependencies between members will be written.", mandatory=true) String filename) {
        ResultModel result = new ResultModel();
        try {
            if (!filename.endsWith(".txt")) {
                return ResultModel.createError(CliStrings.format("Invalid file type, the file extension must be \"{0}\"", (Object)".txt"));
            }
            Set<DistributedMember> allMembers = this.getAllMembers();
            GemFireDeadlockDetector gfeDeadLockDetector = new GemFireDeadlockDetector(allMembers);
            DependencyGraph dependencyGraph = gfeDeadLockDetector.find();
            Collection<Dependency> deadlock = dependencyGraph.findCycle();
            DependencyGraph deepest = null;
            if (deadlock == null && (deepest = dependencyGraph.findLongestCallChain()) != null) {
                deadlock = deepest.getEdges();
            }
            Set dependencies = (Set)dependencyGraph.getEdges();
            InfoResultModel infoResult = result.addInfo();
            if (deadlock != null) {
                if (deepest != null) {
                    infoResult.addLine("No deadlock was detected.  Here is the deepest call chain that could be found");
                } else {
                    infoResult.addLine("Deadlock detected.");
                }
                infoResult.addLine(DeadlockDetector.prettyFormat(deadlock));
            } else {
                infoResult.addLine("No deadlock was detected.");
            }
            result.addFile(filename, DeadlockDetector.prettyFormat(dependencies));
        }
        catch (Exception e) {
            result = ResultModel.createError("Error : " + e.getMessage());
        }
        return result;
    }

    public static class Interceptor
    implements CliAroundInterceptor {
        @Override
        public ResultModel postExecution(GfshParseResult parseResult, ResultModel resultModel, Path tempFile) {
            if (resultModel.getFiles().size() != 1) {
                resultModel.addInfo("No filename found to save");
                resultModel.setStatus(Result.Status.ERROR);
                return resultModel;
            }
            try {
                for (Map.Entry<String, FileResultModel> entry : resultModel.getFiles().entrySet()) {
                    entry.getValue().saveFile();
                    resultModel.addInfo().addLine(MessageFormat.format("Please view the dependencies between the members in file : {0}", entry.getKey()));
                }
            }
            catch (IOException e) {
                resultModel.addInfo().addLine("Unable to save file: " + e.getMessage());
                resultModel.setStatus(Result.Status.ERROR);
            }
            return resultModel;
        }
    }
}

