/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.commands.OfflineGfshCommand;
import org.apache.geode.management.internal.cli.result.ErrorResultData;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class SetVariableCommand
extends OfflineGfshCommand {
    @CliCommand(value={"set variable"}, help="Set GFSH variables that can be used by commands. For example: if variable \"CACHE_SERVERS_GROUP\" is set then to use it with \"list members\", use \"list members --group=${CACHE_SERVERS_GROUP}\". The \"echo\" command can be used to know the value of a variable.")
    @CliMetaData(shellOnly=true, relatedTopic={"GFSH"})
    public Result setVariable(@CliOption(key={"name"}, mandatory=true, help="Name for the variable. Name must only be composed of letters, numbers and the \"_\" character and may not start with a number.") String var, @CliOption(key={"value"}, mandatory=true, help="Value that the variable will be set to.") String value) {
        Result result;
        try {
            this.getGfsh().setEnvProperty(var, String.valueOf(value));
            result = ResultBuilder.createInfoResult("Value for variable " + var + " is now: " + value + ".");
        }
        catch (IllegalArgumentException e) {
            ErrorResultData errorResultData = ResultBuilder.createErrorResultData();
            errorResultData.addLine(e.getMessage());
            result = ResultBuilder.buildResult(errorResultData);
        }
        return result;
    }
}

