/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.control.RebalanceFactory;
import org.apache.geode.cache.control.RebalanceOperation;
import org.apache.geode.cache.control.RebalanceResults;
import org.apache.geode.cache.control.ResourceManager;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.partition.PartitionRebalanceInfo;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.logging.LoggingExecutors;
import org.apache.geode.management.DistributedRegionMXBean;
import org.apache.geode.management.ManagementService;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.GfshCommand;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.MBeanJMXAdapter;
import org.apache.geode.management.internal.cli.LogWrapper;
import org.apache.geode.management.internal.cli.functions.RebalanceFunction;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.result.model.InfoResultModel;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.cli.result.model.TabularResultModel;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class RebalanceCommand
extends GfshCommand {
    @CliCommand(value={"rebalance"}, help="Rebalance partitioned regions. The default is for all partitioned regions to be rebalanced.")
    @CliMetaData(relatedTopic={"Data", "Region"})
    @ResourceOperation(resource=ResourcePermission.Resource.DATA, operation=ResourcePermission.Operation.MANAGE)
    public ResultModel rebalance(@CliOption(key={"include-region"}, help="Partitioned regions to be included when rebalancing. Includes take precedence over excludes.") String[] includeRegions, @CliOption(key={"exclude-region"}, help="Partitioned regions to be excluded when rebalancing.") String[] excludeRegions, @CliOption(key={"time-out"}, unspecifiedDefaultValue="-1", help="Time to wait (in seconds) before GFSH returns to a prompt while rebalancing continues in the background. The default is to wait for rebalancing to complete.") long timeout, @CliOption(key={"simulate"}, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Whether to only simulate rebalancing. The --time-out parameter is not available when simulating.") boolean simulate) throws Exception {
        ResultModel result;
        ExecutorService commandExecutors = LoggingExecutors.newSingleThreadExecutor("RebalanceCommand", false);
        ArrayList<Future<ResultModel>> commandResult = new ArrayList<Future<ResultModel>>();
        try {
            commandResult.add(commandExecutors.submit(new ExecuteRebalanceWithTimeout(includeRegions, excludeRegions, simulate, (InternalCache)this.getCache())));
            Future fs = (Future)commandResult.get(0);
            result = timeout > 0L ? (ResultModel)fs.get(timeout, TimeUnit.SECONDS) : (ResultModel)fs.get();
        }
        catch (TimeoutException timeoutException) {
            result = ResultModel.createInfo("Rebalance will continue in background");
        }
        if (result.getSection("error") != null && result.getSectionSize() == 1) {
            result.setStatus(Result.Status.ERROR);
        }
        return result;
    }

    private boolean checkResultList(InfoResultModel errors, List resultList, DistributedMember member) {
        boolean toContinueForOtherMembers = false;
        if (CollectionUtils.isNotEmpty((Collection)resultList)) {
            for (Object object : resultList) {
                if (object instanceof Exception) {
                    errors.addLine(CliStrings.format("Could not execute for member:{0}", (Object)member.getId()) + ": " + ((Exception)object).getMessage());
                    LogWrapper.getInstance(this.getCache()).info("Could not execute for member:{0}" + member.getId() + " exception=" + ((Throwable)object).getMessage(), (Throwable)object);
                    toContinueForOtherMembers = true;
                } else {
                    if (!(object instanceof Throwable)) continue;
                    errors.addLine(CliStrings.format("Could not execute for member:{0}", (Object)member.getId()) + ": " + ((Throwable)object).getMessage());
                    LogWrapper.getInstance(this.getCache()).info("Could not execute for member:{0}" + member.getId() + " exception=" + ((Throwable)object).getMessage(), (Throwable)object);
                    toContinueForOtherMembers = true;
                }
                break;
            }
        } else {
            LogWrapper.getInstance(this.getCache()).info("Rebalancing for member=" + member.getId() + ", resultList is either null or empty");
            errors.addLine("Rebalancing for member=" + member.getId() + ", resultList is either null or empty");
            toContinueForOtherMembers = true;
        }
        return toContinueForOtherMembers;
    }

    private void toCompositeResultData(ResultModel result, List<String> rstlist, int index, boolean simulate, InternalCache cache) {
        int resultItemCount = 9;
        if (rstlist.size() <= resultItemCount || StringUtils.isEmpty((CharSequence)rstlist.get(resultItemCount))) {
            return;
        }
        TabularResultModel table1 = result.addTable("Table" + index);
        String newLine = System.getProperty("line.separator");
        StringBuilder resultStr = new StringBuilder();
        resultStr.append(newLine);
        table1.accumulate("Rebalanced Stats", "Total bytes in all redundant bucket copies created during this rebalance");
        table1.accumulate("Value", rstlist.get(0));
        resultStr.append("Total bytes in all redundant bucket copies created during this rebalance").append(" = ").append(rstlist.get(0)).append(newLine);
        table1.accumulate("Rebalanced Stats", "Total time (in milliseconds) spent creating redundant bucket copies during this rebalance");
        table1.accumulate("Value", rstlist.get(1));
        resultStr.append("Total time (in milliseconds) spent creating redundant bucket copies during this rebalance").append(" = ").append(rstlist.get(1)).append(newLine);
        table1.accumulate("Rebalanced Stats", "Total number of redundant copies created during this rebalance");
        table1.accumulate("Value", rstlist.get(2));
        resultStr.append("Total number of redundant copies created during this rebalance").append(" = ").append(rstlist.get(2)).append(newLine);
        table1.accumulate("Rebalanced Stats", "Total bytes in buckets moved during this rebalance");
        table1.accumulate("Value", rstlist.get(3));
        resultStr.append("Total bytes in buckets moved during this rebalance").append(" = ").append(rstlist.get(3)).append(newLine);
        table1.accumulate("Rebalanced Stats", "Total time (in milliseconds) spent moving buckets during this rebalance");
        table1.accumulate("Value", rstlist.get(4));
        resultStr.append("Total time (in milliseconds) spent moving buckets during this rebalance").append(" = ").append(rstlist.get(4)).append(newLine);
        table1.accumulate("Rebalanced Stats", "Total number of buckets moved during this rebalance");
        table1.accumulate("Value", rstlist.get(5));
        resultStr.append("Total number of buckets moved during this rebalance").append(" = ").append(rstlist.get(5)).append(newLine);
        table1.accumulate("Rebalanced Stats", "Total time (in milliseconds) spent switching the primary state of buckets during this rebalance");
        table1.accumulate("Value", rstlist.get(6));
        resultStr.append("Total time (in milliseconds) spent switching the primary state of buckets during this rebalance").append(" = ").append(rstlist.get(6)).append(newLine);
        table1.accumulate("Rebalanced Stats", "Total primaries transferred during this rebalance");
        table1.accumulate("Value", rstlist.get(7));
        resultStr.append("Total primaries transferred during this rebalance").append(" = ").append(rstlist.get(7)).append(newLine);
        table1.accumulate("Rebalanced Stats", "Total time (in milliseconds) for this rebalance");
        table1.accumulate("Value", rstlist.get(8));
        resultStr.append("Total time (in milliseconds) for this rebalance").append(" = ").append(rstlist.get(8)).append(newLine);
        String headerText = simulate ? "Simulated partition regions " : "Rebalanced partition regions ";
        for (int i = resultItemCount; i < rstlist.size(); ++i) {
            headerText = headerText + " " + rstlist.get(i);
        }
        table1.setHeader(headerText);
        cache.getLogger().info(headerText + resultStr);
    }

    private DistributedMember getAssociatedMembers(String region, InternalCache cache) {
        DistributedRegionMXBean bean = ManagementService.getManagementService(cache).getDistributedRegionMXBean(region);
        DistributedMember member = null;
        if (bean == null) {
            return null;
        }
        String[] membersName = bean.getMembers();
        Set<DistributedMember> dsMembers = this.getAllMembers();
        Iterator<DistributedMember> it = dsMembers.iterator();
        boolean matchFound = false;
        if (membersName.length > 1) {
            block0: while (it.hasNext() && !matchFound) {
                DistributedMember dsmember = it.next();
                for (String memberName : membersName) {
                    if (!MBeanJMXAdapter.getMemberNameOrUniqueId(dsmember).equals(memberName)) continue;
                    member = dsmember;
                    matchFound = true;
                    continue block0;
                }
            }
        }
        return member;
    }

    private void buildResultForRebalance(ResultModel resultModel, RebalanceResults results, int index, boolean simulate, InternalCache cache) {
        Set<PartitionRebalanceInfo> regions = results.getPartitionRebalanceDetails();
        Iterator<PartitionRebalanceInfo> iterator = regions.iterator();
        if (regions.size() > 0 && StringUtils.isNotEmpty((CharSequence)iterator.next().getRegionPath())) {
            TabularResultModel resultData = resultModel.addTable("Table" + index);
            String newLine = System.getProperty("line.separator");
            StringBuilder resultStr = new StringBuilder();
            resultStr.append(newLine);
            resultData.accumulate("Rebalanced Stats", "Total bytes in all redundant bucket copies created during this rebalance");
            resultData.accumulate("Value", results.getTotalBucketCreateBytes() + "");
            resultStr.append("Total bytes in all redundant bucket copies created during this rebalance").append(" = ").append(results.getTotalBucketCreateBytes()).append(newLine);
            resultData.accumulate("Rebalanced Stats", "Total time (in milliseconds) spent creating redundant bucket copies during this rebalance");
            resultData.accumulate("Value", results.getTotalBucketCreateTime() + "");
            resultStr.append("Total time (in milliseconds) spent creating redundant bucket copies during this rebalance").append(" = ").append(results.getTotalBucketCreateTime()).append(newLine);
            resultData.accumulate("Rebalanced Stats", "Total number of redundant copies created during this rebalance");
            resultData.accumulate("Value", results.getTotalBucketCreatesCompleted() + "");
            resultStr.append("Total number of redundant copies created during this rebalance").append(" = ").append(results.getTotalBucketCreatesCompleted()).append(newLine);
            resultData.accumulate("Rebalanced Stats", "Total bytes in buckets moved during this rebalance");
            resultData.accumulate("Value", results.getTotalBucketTransferBytes() + "");
            resultStr.append("Total bytes in buckets moved during this rebalance").append(" = ").append(results.getTotalBucketTransferBytes()).append(newLine);
            resultData.accumulate("Rebalanced Stats", "Total time (in milliseconds) spent moving buckets during this rebalance");
            resultData.accumulate("Value", results.getTotalBucketTransferTime() + "");
            resultStr.append("Total time (in milliseconds) spent moving buckets during this rebalance").append(" = ").append(results.getTotalBucketTransferTime()).append(newLine);
            resultData.accumulate("Rebalanced Stats", "Total number of buckets moved during this rebalance");
            resultData.accumulate("Value", results.getTotalBucketTransfersCompleted() + "");
            resultStr.append("Total number of buckets moved during this rebalance").append(" = ").append(results.getTotalBucketTransfersCompleted()).append(newLine);
            resultData.accumulate("Rebalanced Stats", "Total time (in milliseconds) spent switching the primary state of buckets during this rebalance");
            resultData.accumulate("Value", results.getTotalPrimaryTransferTime() + "");
            resultStr.append("Total time (in milliseconds) spent switching the primary state of buckets during this rebalance").append(" = ").append(results.getTotalPrimaryTransferTime()).append(newLine);
            resultData.accumulate("Rebalanced Stats", "Total primaries transferred during this rebalance");
            resultData.accumulate("Value", results.getTotalPrimaryTransfersCompleted() + "");
            resultStr.append("Total primaries transferred during this rebalance").append(" = ").append(results.getTotalPrimaryTransfersCompleted()).append(newLine);
            resultData.accumulate("Rebalanced Stats", "Total time (in milliseconds) for this rebalance");
            resultData.accumulate("Value", results.getTotalTime() + "");
            resultStr.append("Total time (in milliseconds) for this rebalance").append(" = ").append(results.getTotalTime()).append(newLine);
            Iterator<PartitionRebalanceInfo> it = regions.iterator();
            String headerText = simulate ? "Simulated partition regions " : "Rebalanced partition regions ";
            while (it.hasNext()) {
                PartitionRebalanceInfo rgn = it.next();
                headerText = headerText + " " + rgn.getRegionPath();
            }
            resultData.setHeader(resultData.getHeader() + headerText);
            cache.getLogger().info(headerText + resultStr);
        }
    }

    private ResultModel executeRebalanceOnDS(InternalCache cache, String simulate, String[] excludeRegionsList) {
        List<MemberPRInfo> listMemberRegion;
        ResultModel resultModel = new ResultModel();
        int index = 1;
        InfoResultModel errors = resultModel.addInfo("errors");
        ArrayList<String> listExcludedRegion = new ArrayList<String>();
        if (excludeRegionsList != null) {
            Collections.addAll(listExcludedRegion, excludeRegionsList);
        }
        if ((listMemberRegion = this.getMemberRegionList(cache, listExcludedRegion)).size() == 0) {
            return ResultModel.createInfo("Distributed system has no regions that can be rebalanced");
        }
        Iterator<MemberPRInfo> iterator = listMemberRegion.iterator();
        boolean flagToContinueWithRebalance = false;
        while (iterator.hasNext()) {
            if (iterator.next().dsMemberList.size() <= 1) continue;
            flagToContinueWithRebalance = true;
            break;
        }
        if (!flagToContinueWithRebalance) {
            return ResultModel.createInfo("Distributed system has no regions that can be rebalanced");
        }
        block5: for (MemberPRInfo memberPR : listMemberRegion) {
            try {
                if (memberPR.dsMemberList.size() <= 1) continue;
                for (int i = 0; i < memberPR.dsMemberList.size(); ++i) {
                    List<String> rstList;
                    HashSet excludeRegionSet;
                    DistributedMember dsMember = memberPR.dsMemberList.get(i);
                    RebalanceFunction rebalanceFunction = new RebalanceFunction();
                    Object[] functionArgs = new Object[3];
                    functionArgs[0] = simulate;
                    HashSet<String> regionSet = new HashSet<String>();
                    regionSet.add(memberPR.region);
                    functionArgs[1] = regionSet;
                    functionArgs[2] = excludeRegionSet = new HashSet();
                    ArrayList resultList = null;
                    try {
                        if (this.checkMemberPresence(dsMember)) {
                            resultList = (ArrayList)this.executeFunction((Function)rebalanceFunction, (Object)functionArgs, dsMember).getResult();
                            if (this.checkResultList(errors, resultList, dsMember)) continue;
                            rstList = Arrays.asList(((String)resultList.get(0)).split(","));
                            this.toCompositeResultData(resultModel, rstList, index, simulate.equals("true"), cache);
                            ++index;
                            continue block5;
                        }
                        if (i != memberPR.dsMemberList.size() - 1) continue;
                        errors.addLine(CliStrings.format("Could not execute rebalance for region: {0} on members : {1} ", memberPR.region, this.listOfAllMembers(memberPR.dsMemberList)) + ", " + " Reason : Members may be departed");
                    }
                    catch (Exception ex) {
                        if (i != memberPR.dsMemberList.size() - 1) continue;
                        errors.addLine(CliStrings.format("Could not execute rebalance for region: {0} on members : {1} ", memberPR.region, this.listOfAllMembers(memberPR.dsMemberList)) + ", " + " Reason : " + ex.getMessage());
                    }
                    if (this.checkResultList(errors, resultList, dsMember)) continue;
                    rstList = Arrays.asList(((String)resultList.get(0)).split(","));
                    this.toCompositeResultData(resultModel, rstList, index, simulate.equals("true"), cache);
                    ++index;
                }
            }
            catch (Exception e) {
                return ResultModel.createError(e.getMessage());
            }
        }
        return resultModel;
    }

    private List<MemberPRInfo> getMemberRegionList(InternalCache cache, List<String> listExcludedRegion) {
        ArrayList<MemberPRInfo> listMemberPRInfo = new ArrayList<MemberPRInfo>();
        String[] listDSRegions = ManagementService.getManagementService(cache).getDistributedSystemMXBean().listRegions();
        Set<DistributedMember> dsMembers = this.getAllMembers();
        for (String regionName : listDSRegions) {
            DistributedRegionMXBean bean;
            boolean excludedRegionMatch = false;
            for (String aListExcludedRegion : listExcludedRegion) {
                String excludedRegion = aListExcludedRegion.trim();
                if (regionName.startsWith("/") && !excludedRegion.startsWith("/")) {
                    excludedRegion = "/" + excludedRegion;
                }
                if (excludedRegion.startsWith("/") && !regionName.startsWith("/")) {
                    regionName = "/" + regionName;
                }
                if (!excludedRegion.equals(regionName)) continue;
                excludedRegionMatch = true;
                break;
            }
            if (excludedRegionMatch) continue;
            if (!regionName.startsWith("/")) {
                regionName = "/" + regionName;
            }
            if ((bean = ManagementService.getManagementService(cache).getDistributedRegionMXBean(regionName)) == null || !bean.getRegionType().equals(DataPolicy.PARTITION.toString()) && !bean.getRegionType().equals(DataPolicy.PERSISTENT_PARTITION.toString())) continue;
            String[] memberNames = bean.getMembers();
            block2: for (DistributedMember dsmember : dsMembers) {
                for (String memberName : memberNames) {
                    if (!MBeanJMXAdapter.getMemberNameOrUniqueId(dsmember).equals(memberName)) continue;
                    MemberPRInfo memberAndItsPRRegions = new MemberPRInfo();
                    memberAndItsPRRegions.region = regionName;
                    memberAndItsPRRegions.dsMemberList.add(dsmember);
                    if (listMemberPRInfo.contains(memberAndItsPRRegions)) {
                        int index = listMemberPRInfo.indexOf(memberAndItsPRRegions);
                        MemberPRInfo listMember = (MemberPRInfo)listMemberPRInfo.get(index);
                        listMember.dsMemberList.add(dsmember);
                        continue block2;
                    }
                    listMemberPRInfo.add(memberAndItsPRRegions);
                    continue block2;
                }
            }
        }
        return listMemberPRInfo;
    }

    private boolean checkMemberPresence(DistributedMember dsMember) {
        Set<DistributedMember> dsMemberList = this.getAllNormalMembers();
        return dsMemberList.contains(dsMember);
    }

    private String listOfAllMembers(ArrayList<DistributedMember> dsMemberList) {
        StringBuilder listMembersId = new StringBuilder();
        for (int j = 0; j < dsMemberList.size() - 1; ++j) {
            listMembersId.append(dsMemberList.get(j).getId());
            listMembersId.append(" ; ");
        }
        return listMembersId.toString();
    }

    private static class MemberPRInfo {
        ArrayList<DistributedMember> dsMemberList = new ArrayList();
        public String region = "";

        MemberPRInfo() {
        }

        public boolean equals(Object o2) {
            return o2 != null && this.region.equals(((MemberPRInfo)o2).region);
        }

        public int hashCode() {
            return this.region.hashCode();
        }
    }

    private class ExecuteRebalanceWithTimeout
    implements Callable<ResultModel> {
        String[] includeRegions = null;
        String[] excludeRegions = null;
        boolean simulate;
        InternalCache cache = null;

        @Override
        public ResultModel call() throws Exception {
            return this.executeRebalanceWithTimeout(this.includeRegions, this.excludeRegions, this.simulate);
        }

        ExecuteRebalanceWithTimeout(String[] includedRegions, String[] excludedRegions, boolean toSimulate, InternalCache cache) {
            this.includeRegions = includedRegions;
            this.excludeRegions = excludedRegions;
            this.simulate = toSimulate;
            this.cache = cache;
        }

        ResultModel executeRebalanceWithTimeout(String[] includeRegions, String[] excludeRegions, boolean simulate) {
            ResultModel result = new ResultModel();
            try {
                if (ArrayUtils.isNotEmpty((Object[])includeRegions)) {
                    InfoResultModel errors = result.addInfo("error");
                    int index = 0;
                    for (String regionName : includeRegions) {
                        regionName = regionName.startsWith("/") ? regionName : "/" + regionName;
                        Region region = this.cache.getRegion(regionName);
                        if (region == null) {
                            List<String> rstList;
                            ArrayList resultList;
                            DistributedMember member = RebalanceCommand.this.getAssociatedMembers(regionName, this.cache);
                            if (member == null) {
                                errors.addLine(CliStrings.format("For the region {0}, no member was found", (Object)regionName));
                                continue;
                            }
                            RebalanceFunction rebalanceFunction = new RebalanceFunction();
                            Object[] functionArgs = new Object[3];
                            functionArgs[0] = simulate ? "true" : "false";
                            HashSet<String> setRegionName = new HashSet<String>();
                            setRegionName.add(regionName);
                            functionArgs[1] = setRegionName;
                            HashSet excludeRegionSet = new HashSet();
                            if (ArrayUtils.isNotEmpty((Object[])excludeRegions)) {
                                Collections.addAll(excludeRegionSet, excludeRegions);
                            }
                            functionArgs[2] = excludeRegionSet;
                            if (simulate) {
                                try {
                                    resultList = (ArrayList)RebalanceCommand.this.executeFunction((Function)rebalanceFunction, (Object)functionArgs, member).getResult();
                                }
                                catch (Exception ex) {
                                    LogWrapper.getInstance(this.cache).info(CliStrings.format("Exception occurred while rebalancing on member : {0} . Exception is : {1}", member.getId(), ex.getMessage()), ex);
                                    errors.addLine(CliStrings.format("Exception occurred while rebalancing on member : {0} . Exception is ", (Object)member.getId()) + ": " + ex.getMessage());
                                    continue;
                                }
                                if (RebalanceCommand.this.checkResultList(errors, resultList, member)) continue;
                                rstList = Arrays.asList(((String)resultList.get(0)).split(","));
                                RebalanceCommand.this.toCompositeResultData(result, rstList, index, true, this.cache);
                            } else {
                                try {
                                    resultList = (ArrayList)RebalanceCommand.this.executeFunction((Function)rebalanceFunction, (Object)functionArgs, member).getResult();
                                }
                                catch (Exception ex) {
                                    LogWrapper.getInstance(this.cache).info(CliStrings.format("Exception occurred while rebalancing on member : {0} . Exception is : {1}", member.getId(), ex.getMessage()), ex);
                                    errors.addLine(CliStrings.format("Exception occurred while rebalancing on member : {0} . Exception is ", (Object)member.getId()) + ": " + ex.getMessage());
                                    continue;
                                }
                                if (RebalanceCommand.this.checkResultList(errors, resultList, member)) continue;
                                rstList = Arrays.asList(((String)resultList.get(0)).split(","));
                                RebalanceCommand.this.toCompositeResultData(result, rstList, index, false, this.cache);
                            }
                        } else {
                            RebalanceOperation op;
                            ResourceManager manager = this.cache.getResourceManager();
                            RebalanceFactory rbFactory = manager.createRebalanceFactory();
                            HashSet<String> excludeRegionSet = new HashSet<String>();
                            if (excludeRegions != null) {
                                Collections.addAll(excludeRegionSet, excludeRegions);
                            }
                            rbFactory.excludeRegions(excludeRegionSet);
                            HashSet<String> includeRegionSet = new HashSet<String>();
                            includeRegionSet.add(regionName);
                            rbFactory.includeRegions(includeRegionSet);
                            if (simulate) {
                                op = manager.createRebalanceFactory().simulate();
                                RebalanceCommand.this.buildResultForRebalance(result, op.getResults(), index, true, this.cache);
                            } else {
                                op = manager.createRebalanceFactory().start();
                                RebalanceCommand.this.buildResultForRebalance(result, op.getResults(), index, false, this.cache);
                            }
                        }
                        ++index;
                    }
                    LogWrapper.getInstance(this.cache).info("Rebalance returning result " + result);
                    return result;
                }
                result = RebalanceCommand.this.executeRebalanceOnDS(this.cache, String.valueOf(simulate), excludeRegions);
                LogWrapper.getInstance(this.cache).info("Starting Rebalance simulate false result >> " + result);
            }
            catch (Exception e) {
                result = ResultModel.createError(e.getMessage());
            }
            LogWrapper.getInstance(this.cache).info("Rebalance returning result >>>" + result);
            return result;
        }
    }
}

