/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.TreeSet;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.membership.MembershipManager;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.internal.cli.commands.InternalGfshCommand;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.cli.result.model.TabularResultModel;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class ListMembersCommand
extends InternalGfshCommand {
    public static final String MEMBERS_SECTION = "members";

    @CliCommand(value={"list members"}, help="Display all or a subset of members.")
    @CliMetaData(relatedTopic={"Server"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.READ)
    public ResultModel listMember(@CliOption(key={"group", "groups"}, optionContext="geode.converter.member.groups:disable-string-converter", help="Group name for which members will be displayed.") String[] groups) {
        ResultModel crm = new ResultModel();
        TreeSet<DistributedMember> memberSet = new TreeSet<DistributedMember>();
        memberSet.addAll(this.findMembersIncludingLocators(groups, null));
        if (memberSet.isEmpty()) {
            crm.addInfo().addLine("No Members Found");
            return crm;
        }
        TabularResultModel resultData = crm.addTable(MEMBERS_SECTION);
        DistributedMember coordinatorMember = this.getCoordinator();
        for (DistributedMember member : memberSet) {
            resultData.accumulate("Name", member.getName());
            if (member == coordinatorMember) {
                resultData.accumulate("Id", member.getId() + " [Coordinator]");
                continue;
            }
            resultData.accumulate("Id", member.getId());
        }
        return crm;
    }

    DistributedMember getCoordinator() {
        InternalDistributedSystem ids = InternalDistributedSystem.getConnectedInstance();
        if (ids == null || !ids.isConnected()) {
            return null;
        }
        MembershipManager mmgr = ids.getDistributionManager().getMembershipManager();
        if (mmgr == null) {
            return null;
        }
        return mmgr.getCoordinator();
    }
}

