/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.GfshCommand;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.functions.ListFunctionFunction;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.cli.result.model.TabularResultModel;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class ListFunctionCommand
extends GfshCommand {
    private final ListFunctionFunction listFunctionFunction = new ListFunctionFunction();

    @CliCommand(value={"list functions"}, help="Display a list of registered functions. The default is to display functions for all members.")
    @CliMetaData(relatedTopic={"Function Execution"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.READ)
    public ResultModel listFunction(@CliOption(key={"matches"}, help="Pattern that the function ID must match in order to be included. Uses Java pattern matching rules, not UNIX. For example, to match any character any number of times use \".*\" instead of \"*\".") String matches, @CliOption(key={"group", "groups"}, optionContext="geode.converter.member.groups:disable-string-converter", help="Group(s) of members for which functions will be displayed.") String[] groups, @CliOption(key={"member", "members"}, optionContext="geode.converter.member.idOrName:disable-string-converter", help="Name/Id of the member(s) for which functions will be displayed.") String[] members) {
        Set<DistributedMember> targetMembers = this.findMembers(groups, members);
        if (targetMembers.isEmpty()) {
            return ResultModel.createError("No Members Found");
        }
        List<CliFunctionResult> results = this.executeAndGetFunctionResult(this.listFunctionFunction, new Object[]{matches}, targetMembers);
        ResultModel result = new ResultModel();
        TabularResultModel tabularData = result.addTable("functions");
        for (CliFunctionResult cliResult : results) {
            Set resultObject = (Set)cliResult.getResultObject();
            if (resultObject == null) continue;
            Object[] strings = resultObject.toArray(new String[0]);
            Arrays.sort(strings);
            for (Object string : strings) {
                tabularData.accumulate("Member", cliResult.getMemberIdOrName());
                tabularData.accumulate("Function", (String)string);
            }
        }
        if (tabularData.getRowSize() == 0) {
            return ResultModel.createInfo("No Functions Found");
        }
        return result;
    }
}

