/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.ObjectName;
import org.apache.geode.management.CacheServerMXBean;
import org.apache.geode.management.ManagementService;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.internal.cli.LogWrapper;
import org.apache.geode.management.internal.cli.commands.InternalGfshCommand;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.result.CompositeResultData;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.cli.result.model.TabularResultModel;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;

public class ListClientCommand
extends InternalGfshCommand {
    @CliCommand(value={"list clients"}, help="Display list of connected clients")
    @CliMetaData(relatedTopic={"Client"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.READ)
    public ResultModel listClient() throws Exception {
        ResultModel result = new ResultModel();
        CompositeResultData compositeResultData = ResultBuilder.createCompositeResultData();
        CompositeResultData.SectionResultData section = compositeResultData.addSection("section1");
        TabularResultModel resultTable = result.addTable("clientList");
        String headerText = "Client List";
        resultTable.setHeader(headerText);
        CacheServerMXBean service = this.getManagementService();
        ObjectName[] cacheServers = ((ManagementService)((Object)service)).getDistributedSystemMXBean().listCacheServerObjectNames();
        if (cacheServers.length == 0) {
            return ResultModel.createError(CliStrings.format("No cache-servers were observed.", new Object[0]));
        }
        HashMap clientServerMap = new HashMap();
        for (ObjectName objName : cacheServers) {
            CacheServerMXBean serverMbean = ((ManagementService)((Object)service)).getMBeanInstance(objName, CacheServerMXBean.class);
            String[] listOfClient = serverMbean.getClientIds();
            if (listOfClient == null || listOfClient.length == 0) continue;
            for (String clientName : listOfClient) {
                String serverDetails = "member=" + objName.getKeyProperty("member") + ",port=" + objName.getKeyProperty("port");
                if (clientServerMap.containsKey(clientName)) {
                    List listServers = (List)clientServerMap.get(clientName);
                    listServers.add(serverDetails);
                    continue;
                }
                ArrayList<String> listServer = new ArrayList<String>();
                listServer.add(serverDetails);
                clientServerMap.put(clientName, listServer);
            }
        }
        if (clientServerMap.size() == 0) {
            return ResultModel.createError(CliStrings.format("No clients were retrieved for cache-servers.", new Object[0]));
        }
        String memberSeparator = ";  ";
        for (Map.Entry pairs : clientServerMap.entrySet()) {
            String client = (String)pairs.getKey();
            List servers = (List)pairs.getValue();
            StringBuilder serverListForClient = new StringBuilder();
            int serversSize = servers.size();
            int i = 0;
            for (String server : servers) {
                serverListForClient.append(server);
                if (i < serversSize - 1) {
                    serverListForClient.append(memberSeparator);
                }
                ++i;
            }
            resultTable.accumulate("Client Name / ID", client);
            resultTable.accumulate("Server Name / ID", serverListForClient.toString());
        }
        LogWrapper.getInstance(this.getCache()).info("list client result " + result);
        return result;
    }
}

