/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ListIterator;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.GfshParser;
import org.apache.geode.management.internal.cli.commands.InternalGfshCommand;
import org.apache.geode.management.internal.cli.result.CommandResult;
import org.apache.geode.management.internal.cli.result.ErrorResultData;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.shell.Gfsh;
import org.apache.geode.management.internal.cli.shell.jline.GfshHistory;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class HistoryCommand
extends InternalGfshCommand {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CliCommand(value={"history"}, help="Display or export previously executed GFSH commands.")
    @CliMetaData(shellOnly=true, relatedTopic={"GFSH"})
    public Result history(@CliOption(key={"file"}, help="File to which the history will be written.") String saveHistoryTo, @CliOption(key={"clear"}, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Clears the history of GFSH commands. Takes value as true or false") Boolean clearHistory) {
        if (clearHistory.booleanValue()) {
            return this.executeClearHistory();
        }
        Gfsh gfsh = Gfsh.getCurrentInstance();
        StringBuilder contents = new StringBuilder();
        Writer output = null;
        int historySize = gfsh.getHistorySize();
        String historySizeString = String.valueOf(historySize);
        int historySizeWordLength = historySizeString.length();
        GfshHistory gfshHistory = gfsh.getGfshHistory();
        ListIterator it = gfshHistory.entries();
        boolean flagForLineNumbers = saveHistoryTo == null || saveHistoryTo.length() <= 0;
        long lineNumber = 0L;
        while (it.hasNext()) {
            String line = it.next().toString();
            if (line.isEmpty()) continue;
            if (flagForLineNumbers) {
                contents.append(String.format("%" + historySizeWordLength + "s  ", ++lineNumber));
            }
            contents.append(line);
            contents.append(GfshParser.LINE_SEPARATOR);
        }
        try {
            if (saveHistoryTo != null && saveHistoryTo.length() > 0) {
                File saveHistoryToFile = new File(saveHistoryTo);
                output = new BufferedWriter(new FileWriter(saveHistoryToFile));
                if (!saveHistoryToFile.exists()) {
                    ErrorResultData errorResultData = ResultBuilder.createErrorResultData().setErrorCode(400).addLine("File does not exist");
                    CommandResult commandResult = ResultBuilder.buildResult(errorResultData);
                    return commandResult;
                }
                if (!saveHistoryToFile.isFile()) {
                    ErrorResultData errorResultData = ResultBuilder.createErrorResultData().setErrorCode(400).addLine("File Should not be a directory");
                    CommandResult commandResult = ResultBuilder.buildResult(errorResultData);
                    return commandResult;
                }
                if (!saveHistoryToFile.canWrite()) {
                    ErrorResultData errorResultData = ResultBuilder.createErrorResultData().setErrorCode(400).addLine("Unable to write to the specified file");
                    CommandResult commandResult = ResultBuilder.buildResult(errorResultData);
                    return commandResult;
                }
                output.write(contents.toString());
            }
        }
        catch (IOException ex) {
            Result result = ResultBuilder.createInfoResult("File error " + ex.getMessage() + " for file " + saveHistoryTo);
            return result;
        }
        finally {
            try {
                if (output != null) {
                    output.close();
                }
            }
            catch (IOException e) {
                ErrorResultData errorResultData = ResultBuilder.createErrorResultData().setErrorCode(400).addLine("exception in closing file");
                return ResultBuilder.buildResult(errorResultData);
            }
        }
        if (saveHistoryTo != null && saveHistoryTo.length() > 0) {
            return ResultBuilder.createInfoResult("Wrote successfully to file " + saveHistoryTo);
        }
        return ResultBuilder.createInfoResult(contents.toString());
    }

    private Result executeClearHistory() {
        Gfsh gfsh = Gfsh.getCurrentInstance();
        gfsh.clearHistory();
        return ResultBuilder.createInfoResult("Successfully deleted history");
    }
}

