/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.Region;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.GfshCommand;
import org.apache.geode.management.internal.cli.commands.DataCommandsUtils;
import org.apache.geode.management.internal.cli.domain.DataCommandRequest;
import org.apache.geode.management.internal.cli.domain.DataCommandResult;
import org.apache.geode.management.internal.cli.functions.DataCommandFunction;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.security.ResourcePermission;
import org.apache.shiro.subject.Subject;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class GetCommand
extends GfshCommand {
    @CliMetaData(relatedTopic={"Data", "Region"})
    @CliCommand(value={"get"}, help="Display an entry in a region. If using a region whose key and value classes have been set, then specifying --key-class and --value-class is unnecessary.")
    public ResultModel get(@CliOption(key={"key"}, mandatory=true, help="String or JSON text from which to create the key.  Examples include: \"James\", \"100L\" and \"('id': 'l34s')\".") String key, @CliOption(key={"region"}, mandatory=true, help="Region from which to get the entry.", optionContext="geode.converter.region.path:disable-string-converter") String regionPath, @CliOption(key={"key-class"}, help="Fully qualified class name of the key's type. The default is the key constraint for the current region or String.") String keyClass, @CliOption(key={"value-class"}, help="Fully qualified class name of the value's type. The default is the value constraint for the current region or String.") String valueClass, @CliOption(key={"load-on-cache-miss"}, unspecifiedDefaultValue="true", specifiedDefaultValue="true", help="Explicitly enables or disables the use of any registered CacheLoaders on the specified Region when retrieving a value for the specified Key on Cache misses. (Default is true, or enabled)") Boolean loadOnCacheMiss) {
        DataCommandResult dataResult;
        Cache cache = this.getCache();
        this.authorize(ResourcePermission.Resource.DATA, ResourcePermission.Operation.READ, regionPath, key);
        key = DataCommandsUtils.makeBrokenJsonCompliant(key);
        Region region = cache.getRegion(regionPath);
        DataCommandFunction getfn = new DataCommandFunction();
        if (region == null) {
            Set<DistributedMember> memberList = this.findAnyMembersForRegion(regionPath);
            if (CollectionUtils.isNotEmpty(memberList)) {
                DataCommandRequest request = new DataCommandRequest();
                request.setCommand("get");
                request.setKey(key);
                request.setKeyClass(keyClass);
                request.setRegionName(regionPath);
                request.setValueClass(valueClass);
                request.setLoadOnCacheMiss(loadOnCacheMiss);
                Subject subject = this.getSubject();
                if (subject != null) {
                    request.setPrincipal(subject.getPrincipal());
                }
                dataResult = DataCommandsUtils.callFunctionForRegion(request, getfn, memberList);
            } else {
                dataResult = DataCommandResult.createGetInfoResult(key, null, null, CliStrings.format("Region <{0}> not found in any of the members", (Object)regionPath), false);
            }
        } else {
            dataResult = getfn.get(null, key, keyClass, valueClass, regionPath, loadOnCacheMiss, (InternalCache)cache);
        }
        dataResult.setKeyClass(keyClass);
        if (valueClass != null) {
            dataResult.setValueClass(valueClass);
        }
        return dataResult.toResultModel();
    }
}

