/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.io.File;
import java.util.List;
import java.util.Set;
import org.apache.geode.cache.configuration.CacheConfig;
import org.apache.geode.cache.configuration.DiskDirType;
import org.apache.geode.cache.configuration.DiskDirsType;
import org.apache.geode.cache.configuration.DiskStoreType;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.cache.DiskStoreAttributes;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.SingleGfshCommand;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.functions.CreateDiskStoreFunction;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class CreateDiskStoreCommand
extends SingleGfshCommand {
    @CliCommand(value={"create disk-store"}, help="Create a disk store.")
    @CliMetaData(relatedTopic={"Disk Store"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE, target=ResourcePermission.Target.DISK)
    public ResultModel createDiskStore(@CliOption(key={"name"}, mandatory=true, optionContext="geode.converter.cluster.diskstore:disable-string-converter", help="Name of the disk store to be created.") String name, @CliOption(key={"allow-force-compaction"}, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Whether to allow manual compaction through the API or command-line tools.") boolean allowForceCompaction, @CliOption(key={"auto-compact"}, specifiedDefaultValue="true", unspecifiedDefaultValue="true", help="Whether to automatically compact a file when it reaches the compaction-threshold.") boolean autoCompact, @CliOption(key={"compaction-threshold"}, unspecifiedDefaultValue="50", help="Percentage of garbage allowed in the file before it is eligible for compaction.") int compactionThreshold, @CliOption(key={"max-oplog-size"}, unspecifiedDefaultValue="1024", help="The largest size, in megabytes, to allow an operation log to become before automatically rolling to a new file.") int maxOplogSize, @CliOption(key={"queue-size"}, unspecifiedDefaultValue="0", help="For asynchronous queueing. The maximum number of operations to allow into the write queue before automatically flushing the queue. The default of 0 indicates no limit.") int queueSize, @CliOption(key={"time-interval"}, unspecifiedDefaultValue="1000", help="For asynchronous queueing. The number of milliseconds that can elapse before data is flushed to disk. Reaching this limit or the queue-size limit causes the queue to flush.") long timeInterval, @CliOption(key={"write-buffer-size"}, unspecifiedDefaultValue="32768", help="Size of the buffer used to write to disk.") int writeBufferSize, @CliOption(key={"dir"}, mandatory=true, help="Directories where the disk store files will be written, the directories will be created if they don't exist.  Optionally, directory names may be followed by # and the maximum number of megabytes that the disk store can use in the directory.  Example: --dir=/data/ds1 --dir=/data/ds2#5000") String[] directoriesAndSizes, @CliOption(key={"group", "groups"}, help="Group(s) of members on which the disk store will be created. If no group is specified the disk store will be created on all members.", optionContext="geode.converter.member.groups:disable-string-converter") String[] groups, @CliOption(key={"disk-usage-warning-percentage"}, unspecifiedDefaultValue="90", help="Warning percentage for disk volume usage.") float diskUsageWarningPercentage, @CliOption(key={"disk-usage-critical-percentage"}, unspecifiedDefaultValue="99", help="Critical percentage for disk volume usage.") float diskUsageCriticalPercentage) {
        DiskStoreAttributes diskStoreAttributes = new DiskStoreAttributes();
        diskStoreAttributes.allowForceCompaction = allowForceCompaction;
        diskStoreAttributes.autoCompact = autoCompact;
        diskStoreAttributes.compactionThreshold = compactionThreshold;
        diskStoreAttributes.maxOplogSizeInBytes = (long)maxOplogSize * 0x100000L;
        diskStoreAttributes.queueSize = queueSize;
        diskStoreAttributes.timeInterval = timeInterval;
        diskStoreAttributes.writeBufferSize = writeBufferSize;
        diskStoreAttributes.name = name;
        File[] directories = new File[directoriesAndSizes.length];
        int[] sizes = new int[directoriesAndSizes.length];
        for (int i = 0; i < directoriesAndSizes.length; ++i) {
            int hashPosition = directoriesAndSizes[i].indexOf(35);
            if (hashPosition == -1) {
                directories[i] = new File(directoriesAndSizes[i]);
                sizes[i] = Integer.MAX_VALUE;
                continue;
            }
            directories[i] = new File(directoriesAndSizes[i].substring(0, hashPosition));
            sizes[i] = Integer.parseInt(directoriesAndSizes[i].substring(hashPosition + 1));
        }
        diskStoreAttributes.diskDirs = directories;
        diskStoreAttributes.diskDirSizes = sizes;
        diskStoreAttributes.setDiskUsageWarningPercentage(diskUsageWarningPercentage);
        diskStoreAttributes.setDiskUsageCriticalPercentage(diskUsageCriticalPercentage);
        Set<DistributedMember> targetMembers = this.findMembers(groups, null);
        if (targetMembers.isEmpty()) {
            return ResultModel.createError("No Members Found");
        }
        List<CliFunctionResult> functionResults = this.executeAndGetFunctionResult(new CreateDiskStoreFunction(), new Object[]{name, diskStoreAttributes}, targetMembers);
        ResultModel result = ResultModel.createMemberStatusResult(functionResults);
        result.setConfigObject(this.createDiskStoreType(name, diskStoreAttributes));
        return result;
    }

    private DiskStoreType createDiskStoreType(String name, DiskStoreAttributes diskStoreAttributes) {
        DiskStoreType diskStoreType = new DiskStoreType();
        diskStoreType.setAllowForceCompaction(Boolean.valueOf(diskStoreAttributes.getAllowForceCompaction()));
        diskStoreType.setAutoCompact(Boolean.valueOf(diskStoreAttributes.getAutoCompact()));
        diskStoreType.setCompactionThreshold(Integer.toString(diskStoreAttributes.getCompactionThreshold()));
        DiskDirsType diskDirsType = new DiskDirsType();
        List diskDirs = diskDirsType.getDiskDirs();
        for (int i = 0; i < diskStoreAttributes.getDiskDirs().length; ++i) {
            DiskDirType diskDir = new DiskDirType();
            File diskDirFile = diskStoreAttributes.getDiskDirs()[i];
            diskDir.setContent(diskDirFile.isAbsolute() ? diskDirFile.getAbsolutePath() : diskDirFile.getName());
            diskDir.setDirSize(Integer.toString(diskStoreAttributes.getDiskDirSizes()[i]));
            diskDirs.add(diskDir);
        }
        diskStoreType.setDiskDirs(diskDirsType);
        diskStoreType.setDiskUsageCriticalPercentage(Integer.toString((int)diskStoreAttributes.getDiskUsageCriticalPercentage()));
        diskStoreType.setDiskUsageWarningPercentage(Integer.toString((int)diskStoreAttributes.getDiskUsageWarningPercentage()));
        diskStoreType.setMaxOplogSize(Integer.toString((int)diskStoreAttributes.getMaxOplogSize()));
        diskStoreType.setName(diskStoreAttributes.getName());
        diskStoreType.setQueueSize(Integer.toString(diskStoreAttributes.getQueueSize()));
        diskStoreType.setTimeInterval(Integer.toString((int)diskStoreAttributes.getTimeInterval()));
        diskStoreType.setWriteBufferSize(Integer.toString(diskStoreAttributes.getWriteBufferSize()));
        return diskStoreType;
    }

    @Override
    public boolean updateConfigForGroup(String group, CacheConfig config, Object configObject) {
        DiskStoreType diskStoreType = (DiskStoreType)configObject;
        config.getDiskStores().add(diskStoreType);
        return true;
    }
}

