/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.cache.CacheListener;
import org.apache.geode.cache.CacheLoader;
import org.apache.geode.cache.CacheWriter;
import org.apache.geode.cache.CustomExpiry;
import org.apache.geode.cache.ExpirationAction;
import org.apache.geode.cache.configuration.CacheConfig;
import org.apache.geode.cache.configuration.CacheElement;
import org.apache.geode.cache.configuration.DeclarableType;
import org.apache.geode.cache.configuration.RegionAttributesType;
import org.apache.geode.cache.configuration.RegionConfig;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.SingleGfshCommand;
import org.apache.geode.management.internal.cli.domain.ClassName;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.functions.RegionAlterFunction;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.exceptions.EntityNotFoundException;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class AlterRegionCommand
extends SingleGfshCommand {
    @CliCommand(value={"alter region"}, help="Alter a region with the given path and configuration.")
    @CliMetaData(relatedTopic={"Region"})
    public ResultModel alterRegion(@CliOption(key={"name"}, mandatory=true, optionContext="geode.converter.region.path:disable-string-converter", help="Name/Path of the region to be altered.") String regionPath, @CliOption(key={"group", "groups"}, optionContext="geode.converter.member.groups:disable-string-converter", help="Group(s) of members on which the region will be altered.") String[] groups, @CliOption(key={"entry-idle-time-expiration"}, help="How long the region's entries can remain in the cache without being accessed. The default is no expiration of this type.") Integer entryExpirationIdleTime, @CliOption(key={"entry-idle-time-expiration-action"}, specifiedDefaultValue="INVALIDATE", help="Action to be taken on an entry that has exceeded the idle expiration.") ExpirationAction entryExpirationIdleTimeAction, @CliOption(key={"entry-time-to-live-expiration"}, help="How long the region's entries can remain in the cache without being accessed or updated. The default is no expiration of this type.") Integer entryExpirationTTL, @CliOption(key={"entry-time-to-live-expiration-action"}, specifiedDefaultValue="INVALIDATE", help="Action to be taken on an entry that has exceeded the TTL expiration.") ExpirationAction entryExpirationTTLAction, @CliOption(key={"entry-idle-time-custom-expiry"}, specifiedDefaultValue="", help="The name of the class implementing CustomExpiry for entry idle time. Append json string for initialization properties.") ClassName<CustomExpiry> entryIdleTimeCustomExpiry, @CliOption(key={"entry-time-to-live-custom-expiry"}, specifiedDefaultValue="", help="The name of the class implementing CustomExpiry for entry time to live. Append json string for initialization properties.") ClassName<CustomExpiry> entryTTLCustomExpiry, @CliOption(key={"region-idle-time-expiration"}, help="How long the region can remain in the cache without being accessed. The default is no expiration of this type.") Integer regionExpirationIdleTime, @CliOption(key={"region-idle-time-expiration-action"}, specifiedDefaultValue="INVALIDATE", help="Action to be taken on a region that has exceeded the idle expiration.") ExpirationAction regionExpirationIdleTimeAction, @CliOption(key={"region-time-to-live-expiration"}, help="How long the region can remain in the cache without being accessed or updated. The default is no expiration of this type.") Integer regionExpirationTTL, @CliOption(key={"region-time-to-live-expiration-action"}, specifiedDefaultValue="INVALIDATE", help="Action to be taken on a region that has exceeded the TTL expiration.") ExpirationAction regionExpirationTTLAction, @CliOption(key={"cache-listener"}, specifiedDefaultValue="", optionContext="splittingRegex=,(?![^{]*\\})", help="Fully qualified class name of a plug-in to be instantiated for receiving after-event notification of changes to the region and its entries. Any number of cache listeners can be configured.") ClassName<CacheListener>[] cacheListeners, @CliOption(key={"cache-loader"}, specifiedDefaultValue="", help="Fully qualified class name of a plug-in to be instantiated for receiving notification of cache misses in the region. At most, one cache loader can be defined in each member for the region. For distributed regions, a cache loader may be invoked remotely from other members that have the region defined.") ClassName<CacheLoader> cacheLoader, @CliOption(key={"cache-writer"}, specifiedDefaultValue="", help="Fully qualified class name of a plug-in to be instantiated for receiving before-event notification of changes to the region and its entries. The plug-in may cancel the event. At most, one cache writer can be defined in each member for the region.") ClassName<CacheWriter> cacheWriter, @CliOption(key={"async-event-queue-id"}, specifiedDefaultValue="", help="IDs of the Async Event Queues that will be used for write-behind operations.") String[] asyncEventQueueIds, @CliOption(key={"gateway-sender-id"}, specifiedDefaultValue="", help="IDs of the Gateway Senders to which data will be routed.") String[] gatewaySenderIds, @CliOption(key={"enable-cloning"}, specifiedDefaultValue="true", help="Determines how fromDelta applies deltas to the local cache for delta propagation. When true, the updates are applied to a clone of the value and then the clone is saved to the cache. When false, the value is modified in place in the cache.") Boolean cloningEnabled, @CliOption(key={"eviction-max"}, specifiedDefaultValue="0", help="Maximum value for the Eviction Attributes which the Eviction Algorithm uses to determine when to perform its Eviction Action. The unit of the maximum value is determined by the Eviction Algorithm.") Integer evictionMax) {
        this.authorize(ResourcePermission.Resource.DATA, ResourcePermission.Operation.MANAGE, regionPath);
        Set<DistributedMember> targetMembers = this.findMembers(groups, null);
        if (targetMembers.isEmpty()) {
            return ResultModel.createError("No Members Found");
        }
        Object ccService = this.getConfigurationPersistenceService();
        if (groups == null) {
            groups = new String[]{"cluster"};
        }
        if (ccService != null) {
            for (String group : groups) {
                CacheConfig clusterConfig = ccService.getCacheConfig(group);
                RegionConfig regionConfig = null;
                if (clusterConfig != null) {
                    regionConfig = (RegionConfig)CacheElement.findElement((List)clusterConfig.getRegions(), (String)regionPath.substring(1));
                }
                if (regionConfig != null) continue;
                throw new EntityNotFoundException(String.format("%s does not exist in group %s", regionPath, group));
            }
        }
        RegionConfig deltaConfig = new RegionConfig();
        deltaConfig.setName(regionPath);
        RegionAttributesType regionAttributesType = new RegionAttributesType();
        deltaConfig.setRegionAttributes(regionAttributesType);
        regionAttributesType.setEntryIdleTime(RegionAttributesType.ExpirationAttributesType.generate((Integer)entryExpirationIdleTime, (ExpirationAction)entryExpirationIdleTimeAction, entryIdleTimeCustomExpiry));
        regionAttributesType.setEntryTimeToLive(RegionAttributesType.ExpirationAttributesType.generate((Integer)entryExpirationTTL, (ExpirationAction)entryExpirationTTLAction, entryTTLCustomExpiry));
        regionAttributesType.setRegionIdleTime(RegionAttributesType.ExpirationAttributesType.generate((Integer)regionExpirationIdleTime, (ExpirationAction)regionExpirationIdleTimeAction, null));
        regionAttributesType.setRegionTimeToLive(RegionAttributesType.ExpirationAttributesType.generate((Integer)regionExpirationTTL, (ExpirationAction)regionExpirationTTLAction, null));
        if (cacheLoader != null) {
            regionAttributesType.setCacheLoader(new DeclarableType(cacheLoader.getClassName(), cacheLoader.getInitProperties()));
        }
        if (cacheWriter != null) {
            regionAttributesType.setCacheWriter(new DeclarableType(cacheLoader.getClassName(), cacheLoader.getInitProperties()));
        }
        if (cacheListeners != null) {
            regionAttributesType.getCacheListeners().addAll(Arrays.stream(cacheListeners).map(l -> new DeclarableType(l.getClassName(), l.getInitProperties())).collect(Collectors.toList()));
        }
        if (gatewaySenderIds != null) {
            regionAttributesType.setGatewaySenderIds(StringUtils.join((Object[])gatewaySenderIds, (String)","));
        }
        if (asyncEventQueueIds != null) {
            regionAttributesType.setAsyncEventQueueIds(StringUtils.join((Object[])asyncEventQueueIds, (String)","));
        }
        if (cloningEnabled != null) {
            regionAttributesType.setCloningEnabled(cloningEnabled);
        }
        if (evictionMax != null && evictionMax < 0) {
            throw new IllegalArgumentException(CliStrings.format("Specify 0 or a positive integer value for eviction-max.  \"{0}\" is not valid.", (Object)evictionMax));
        }
        if (evictionMax != null) {
            RegionAttributesType.EvictionAttributes evictionAttributes = new RegionAttributesType.EvictionAttributes();
            RegionAttributesType.EvictionAttributes.LruEntryCount lruEntryCount = new RegionAttributesType.EvictionAttributes.LruEntryCount();
            lruEntryCount.setMaximum(evictionMax.toString());
            evictionAttributes.setLruEntryCount(lruEntryCount);
            regionAttributesType.setEvictionAttributes(evictionAttributes);
        }
        List<CliFunctionResult> regionAlterResults = this.executeAndGetFunctionResult(new RegionAlterFunction(), deltaConfig, targetMembers);
        ResultModel result = ResultModel.createMemberStatusResult(regionAlterResults);
        result.setConfigObject(deltaConfig);
        return result;
    }

    @Override
    public boolean updateConfigForGroup(String group, CacheConfig cacheConfig, Object configObject) {
        RegionAttributesType.EvictionAttributes evictionAttributes;
        RegionConfig deltaConfig = (RegionConfig)configObject;
        RegionConfig existingConfig = (RegionConfig)CacheElement.findElement((List)cacheConfig.getRegions(), (String)deltaConfig.getId());
        RegionAttributesType deltaAttributes = deltaConfig.getRegionAttributes();
        RegionAttributesType existingAttributes = existingConfig.getRegionAttributes();
        existingAttributes.setEntryIdleTime(RegionAttributesType.ExpirationAttributesType.combine((RegionAttributesType.ExpirationAttributesType)existingAttributes.getEntryIdleTime(), (RegionAttributesType.ExpirationAttributesType)deltaAttributes.getEntryIdleTime()));
        existingAttributes.setEntryTimeToLive(RegionAttributesType.ExpirationAttributesType.combine((RegionAttributesType.ExpirationAttributesType)existingAttributes.getEntryTimeToLive(), (RegionAttributesType.ExpirationAttributesType)deltaAttributes.getEntryTimeToLive()));
        existingAttributes.setRegionIdleTime(RegionAttributesType.ExpirationAttributesType.combine((RegionAttributesType.ExpirationAttributesType)existingAttributes.getRegionIdleTime(), (RegionAttributesType.ExpirationAttributesType)deltaAttributes.getRegionIdleTime()));
        existingAttributes.setRegionTimeToLive(RegionAttributesType.ExpirationAttributesType.combine((RegionAttributesType.ExpirationAttributesType)existingAttributes.getRegionTimeToLive(), (RegionAttributesType.ExpirationAttributesType)deltaAttributes.getRegionTimeToLive()));
        if (deltaAttributes.getCacheLoader() != null) {
            if (deltaAttributes.getCacheLoader().equals((Object)DeclarableType.EMPTY)) {
                existingAttributes.setCacheLoader(null);
            } else {
                existingAttributes.setCacheLoader(deltaAttributes.getCacheLoader());
            }
        }
        if (deltaAttributes.getCacheWriter() != null) {
            if (deltaAttributes.getCacheWriter().equals((Object)DeclarableType.EMPTY)) {
                existingAttributes.setCacheWriter(null);
            } else {
                existingAttributes.setCacheWriter(deltaAttributes.getCacheWriter());
            }
        }
        if (!deltaAttributes.getCacheListeners().isEmpty()) {
            existingAttributes.getCacheListeners().clear();
            if (!((DeclarableType)deltaAttributes.getCacheListeners().get(0)).equals((Object)DeclarableType.EMPTY)) {
                existingAttributes.getCacheListeners().addAll(deltaAttributes.getCacheListeners());
            }
        }
        if (deltaAttributes.getGatewaySenderIds() != null) {
            existingAttributes.setGatewaySenderIds(deltaAttributes.getGatewaySenderIds());
        }
        if (deltaAttributes.getAsyncEventQueueIds() != null) {
            existingAttributes.setAsyncEventQueueIds(deltaAttributes.getAsyncEventQueueIds());
        }
        if (deltaAttributes.isCloningEnabled() != null) {
            existingAttributes.setCloningEnabled(deltaAttributes.isCloningEnabled());
        }
        if ((evictionAttributes = deltaAttributes.getEvictionAttributes()) != null) {
            String newMax = evictionAttributes.getLruEntryCount().getMaximum();
            RegionAttributesType.EvictionAttributes existingEviction = existingAttributes.getEvictionAttributes();
            if (existingEviction != null) {
                if (existingEviction.getLruEntryCount() != null) {
                    existingEviction.getLruEntryCount().setMaximum(newMax);
                }
                if (existingEviction.getLruMemorySize() != null) {
                    existingEviction.getLruMemorySize().setMaximum(newMax);
                }
            }
        }
        return true;
    }
}

