/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.api;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.cache.configuration.CacheConfig;
import org.apache.geode.cache.configuration.CacheElement;
import org.apache.geode.cache.configuration.RegionConfig;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.ConfigurationPersistenceService;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.management.api.ClusterManagementResult;
import org.apache.geode.management.api.ClusterManagementService;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.functions.UpdateCacheFunction;
import org.apache.geode.management.internal.configuration.mutators.ConfigurationMutator;
import org.apache.geode.management.internal.configuration.mutators.RegionConfigMutator;
import org.apache.geode.management.internal.configuration.validators.ConfigurationValidator;
import org.apache.geode.management.internal.configuration.validators.RegionConfigValidator;
import org.apache.geode.management.internal.exceptions.EntityExistsException;
import org.apache.logging.log4j.Logger;

public class LocatorClusterManagementService
implements ClusterManagementService {
    private static final Logger logger = LogService.getLogger();
    private DistributionManager distributionManager;
    private ConfigurationPersistenceService persistenceService;
    private HashMap<Class, ConfigurationMutator> mutators;
    private HashMap<Class, ConfigurationValidator> validators;

    public LocatorClusterManagementService(DistributionManager distributionManager, ConfigurationPersistenceService persistenceService) {
        this(distributionManager, persistenceService, new HashMap(), new HashMap());
        this.mutators.put(RegionConfig.class, new RegionConfigMutator());
        this.validators.put(RegionConfig.class, new RegionConfigValidator());
    }

    @VisibleForTesting
    public LocatorClusterManagementService(DistributionManager distributionManager, ConfigurationPersistenceService persistenceService, HashMap mutators, HashMap validators) {
        this.distributionManager = distributionManager;
        this.persistenceService = persistenceService;
        this.mutators = mutators;
        this.validators = validators;
    }

    public ClusterManagementResult create(CacheElement config, String group) {
        CacheConfig currentPersistedConfig;
        if (group == null) {
            group = "cluster";
        }
        if (this.persistenceService == null) {
            return new ClusterManagementResult(false, "Cluster configuration service needs to be enabled");
        }
        ClusterManagementResult result = new ClusterManagementResult();
        ConfigurationMutator configurationMutator = this.mutators.get(config.getClass());
        ConfigurationValidator validator = this.validators.get(config.getClass());
        if (validator != null) {
            validator.validate(config);
        }
        if (validator.exists(config, currentPersistedConfig = this.persistenceService.getCacheConfig(group, true))) {
            throw new EntityExistsException("cache element " + (String)((Object)config.getId()) + " already exists.");
        }
        Set<DistributedMember> targetedMembers = this.findMembers(null, null);
        if (targetedMembers.size() == 0) {
            return new ClusterManagementResult(false, "no members found to create cache element");
        }
        List<CliFunctionResult> functionResults = this.executeAndGetFunctionResult(new UpdateCacheFunction(), Arrays.asList(new Serializable[]{config, UpdateCacheFunction.CacheElementOperation.ADD}), targetedMembers);
        functionResults.forEach(functionResult -> result.addMemberStatus(functionResult.getMemberIdOrName(), functionResult.isSuccessful(), functionResult.getStatusMessage()));
        if (result.getStatusCode() != ClusterManagementResult.StatusCode.OK) {
            result.setStatus(false, "Failed to apply the update on all members.");
            return result;
        }
        String finalGroup = group;
        this.persistenceService.updateCacheConfig(finalGroup, cacheConfigForGroup -> {
            try {
                configurationMutator.add(config, (CacheConfig)cacheConfigForGroup);
                result.setStatus(true, "successfully persisted config for " + finalGroup);
            }
            catch (Exception e) {
                String message = "failed to update cluster config for " + finalGroup;
                logger.error(message, (Throwable)e);
                result.setStatus(ClusterManagementResult.StatusCode.FAIL_TO_PERSIST, message);
                return null;
            }
            return cacheConfigForGroup;
        });
        return result;
    }

    public ClusterManagementResult delete(CacheElement config, String group) {
        throw new NotImplementedException("Not implemented");
    }

    public ClusterManagementResult update(CacheElement config, String group) {
        throw new NotImplementedException("Not implemented");
    }

    @VisibleForTesting
    Set<DistributedMember> findMembers(String[] groups, String[] members) {
        return CliUtil.findMembers(groups, members, this.distributionManager);
    }

    @VisibleForTesting
    List<CliFunctionResult> executeAndGetFunctionResult(Function function, Object args, Set<DistributedMember> targetMembers) {
        ResultCollector<?, ?> rc = CliUtil.executeFunction(function, args, targetMembers);
        return CliFunctionResult.cleanResults((List)rc.getResult());
    }
}

