/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import javax.management.Notification;
import javax.management.ObjectName;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.cache.AttributesFactory;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.EvictionAction;
import org.apache.geode.cache.EvictionAttributes;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.RegionExistsException;
import org.apache.geode.cache.Scope;
import org.apache.geode.cache.TimeoutException;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.CachePerfStats;
import org.apache.geode.internal.cache.HasCachePerfStats;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalRegionArguments;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.LoggingExecutors;
import org.apache.geode.management.ManagementException;
import org.apache.geode.management.internal.MBeanJMXAdapter;
import org.apache.geode.management.internal.MBeanProxyFactory;
import org.apache.geode.management.internal.ManagementCacheListener;
import org.apache.geode.management.internal.ManagementResourceRepo;
import org.apache.geode.management.internal.Manager;
import org.apache.geode.management.internal.MemberMessenger;
import org.apache.geode.management.internal.NotificationCacheListener;
import org.apache.geode.management.internal.NotificationKey;
import org.apache.geode.management.internal.SystemManagementService;
import org.apache.logging.log4j.Logger;

public class FederatingManager
extends Manager {
    public static final Logger logger = LogService.getLogger();
    private ExecutorService pooledMembershipExecutor;
    private MBeanProxyFactory proxyFactory;
    private MemberMessenger messenger;
    private final SystemManagementService service;
    private final AtomicReference<Exception> latestException = new AtomicReference<Object>(null);

    FederatingManager(MBeanJMXAdapter jmxAdapter, ManagementResourceRepo repo, InternalDistributedSystem system, SystemManagementService service, InternalCache cache) {
        super(repo, system, cache);
        this.service = service;
        this.proxyFactory = new MBeanProxyFactory(jmxAdapter, service);
        this.messenger = new MemberMessenger(jmxAdapter, system);
    }

    @VisibleForTesting
    void setProxyFactory(MBeanProxyFactory newProxyFactory) {
        this.proxyFactory = newProxyFactory;
    }

    @Override
    public synchronized void startManager() {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Starting the Federating Manager.... ");
            }
            this.pooledMembershipExecutor = LoggingExecutors.newFixedThreadPool("FederatingManager", false, Runtime.getRuntime().availableProcessors());
            this.running = true;
            this.startManagingActivity();
            this.messenger.broadcastManagerInfo();
        }
        catch (Exception e) {
            this.running = false;
            throw new ManagementException(e);
        }
    }

    @Override
    public synchronized void stopManager() {
        if (!this.running) {
            return;
        }
        this.running = false;
        if (logger.isDebugEnabled()) {
            logger.debug("Stopping the Federating Manager.... ");
        }
        this.stopManagingActivity();
    }

    private void stopManagingActivity() {
        try {
            this.pooledMembershipExecutor.shutdownNow();
            for (DistributedMember distributedMember : this.repo.getMonitoringRegionMap().keySet()) {
                this.removeMemberArtifacts(distributedMember, false);
            }
        }
        catch (Exception e) {
            throw new ManagementException(e);
        }
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    public void addMember(DistributedMember member) {
        GIITask giiTask = new GIITask(member);
        this.executeTask(() -> {
            try {
                giiTask.call();
            }
            catch (Exception e) {
                logger.warn("Error federating new member {}", (Object)member.getId(), (Object)e);
                this.latestException.set(e);
            }
        });
    }

    public void removeMember(DistributedMember member, boolean crashed) {
        RemoveMemberTask removeTask = new RemoveMemberTask(member, crashed);
        this.executeTask(removeTask);
    }

    private void executeTask(Runnable task) {
        try {
            this.pooledMembershipExecutor.execute(task);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    private void removeMemberArtifacts(DistributedMember member, boolean crashed) {
        Region<String, Object> proxyRegion = this.repo.getEntryFromMonitoringRegionMap(member);
        Region<NotificationKey, Notification> notificationRegion = this.repo.getEntryFromNotifRegionMap(member);
        if (proxyRegion == null && notificationRegion == null) {
            return;
        }
        this.repo.romoveEntryFromMonitoringRegionMap(member);
        this.repo.removeEntryFromNotifRegionMap(member);
        if (!this.cache.isClosed()) {
            this.proxyFactory.removeAllProxies(member, proxyRegion);
            proxyRegion.localDestroyRegion();
            notificationRegion.localDestroyRegion();
        }
        if (!this.cache.getDistributedSystem().getDistributedMember().equals(member)) {
            this.service.memberDeparted((InternalDistributedMember)member, crashed);
        }
    }

    public void suspectMember(DistributedMember member, InternalDistributedMember whoSuspected, String reason) {
        this.service.memberSuspect((InternalDistributedMember)member, whoSuspected, reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startManagingActivity() {
        boolean isDebugEnabled = logger.isDebugEnabled();
        ArrayList<GIITask> giiTaskList = new ArrayList<GIITask>();
        for (DistributedMember distributedMember : this.cache.getDistributionManager().getOtherDistributionManagerIds()) {
            giiTaskList.add(new GIITask(distributedMember));
        }
        try {
            if (isDebugEnabled) {
                logger.debug("Management Resource creation started  : ");
            }
            List futureTaskList = this.pooledMembershipExecutor.invokeAll(giiTaskList);
            for (Future futureTask : futureTaskList) {
                try {
                    String memberId;
                    DistributedMember returnedMember = (DistributedMember)futureTask.get();
                    String string = memberId = returnedMember != null ? returnedMember.getId() : null;
                    if (futureTask.isDone() && isDebugEnabled) {
                        logger.debug("Monitoring Resource Created for : {}", (Object)memberId);
                    }
                    if (!futureTask.isCancelled() || !isDebugEnabled) continue;
                    logger.debug("Monitoring resource Creation Failed for : {}", (Object)memberId);
                }
                catch (ExecutionException e) {
                    if (!isDebugEnabled) continue;
                    logger.debug("ExecutionException during Management GII", (Throwable)e);
                }
                catch (CancellationException e) {
                    if (!isDebugEnabled) continue;
                    logger.debug("InterruptedException while creating Monitoring resource with error", (Throwable)new ManagementException(e));
                }
            }
        }
        catch (InterruptedException e) {
            if (isDebugEnabled) {
                logger.debug("InterruptedException while creating Monitoring resource with error", (Throwable)new ManagementException(e));
            }
        }
        finally {
            if (isDebugEnabled) {
                logger.debug("Management Resource creation completed");
            }
        }
    }

    public MBeanProxyFactory getProxyFactory() {
        return this.proxyFactory;
    }

    long getLastUpdateTime(ObjectName objectName) {
        return this.proxyFactory.getLastUpdateTime(objectName);
    }

    <T> T findProxy(ObjectName objectName, Class<T> interfaceClass) {
        return this.proxyFactory.findProxy(objectName, interfaceClass);
    }

    Set<ObjectName> findAllProxies(DistributedMember member) {
        return this.proxyFactory.findAllProxies(member);
    }

    public MemberMessenger getMessenger() {
        return this.messenger;
    }

    @VisibleForTesting
    public void setMessenger(MemberMessenger messenger) {
        this.messenger = messenger;
    }

    @VisibleForTesting
    public synchronized Exception getAndResetLatestException() {
        return this.latestException.getAndSet(null);
    }

    private class GIITask
    implements Callable<DistributedMember> {
        private final DistributedMember member;

        GIITask(DistributedMember member) {
            this.member = member;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public DistributedMember call() {
            DistributedMember distributedMember = this.member;
            synchronized (distributedMember) {
                block23: {
                    String appender = MBeanJMXAdapter.getUniqueIDForMember(this.member);
                    String monitoringRegionName = "_monitoringRegion_" + appender;
                    String notificationRegionName = "_notificationRegion_" + appender;
                    if (FederatingManager.this.cache.getInternalRegion(monitoringRegionName) != null && FederatingManager.this.cache.getInternalRegion(notificationRegionName) != null) {
                        return this.member;
                    }
                    try {
                        Region<NotificationKey, Notification> proxyNotificationRegion;
                        boolean proxyMonitoringRegionCreated;
                        Region<String, Object> proxyMonitoringRegion;
                        if (Thread.currentThread().isInterrupted()) break block23;
                        InternalRegionArguments internalRegionArguments = new InternalRegionArguments();
                        internalRegionArguments.setIsUsedForMetaRegion(true);
                        HasCachePerfStats monitoringRegionStats = () -> new CachePerfStats(FederatingManager.this.cache.getDistributedSystem(), "managementRegionStats");
                        internalRegionArguments.setCachePerfStatsHolder(monitoringRegionStats);
                        AttributesFactory<String, Object> monitorAttributesFactory = new AttributesFactory<String, Object>();
                        monitorAttributesFactory.setScope(Scope.DISTRIBUTED_NO_ACK);
                        monitorAttributesFactory.setDataPolicy(DataPolicy.REPLICATE);
                        monitorAttributesFactory.setConcurrencyChecksEnabled(false);
                        ManagementCacheListener managementCacheListener = new ManagementCacheListener(FederatingManager.this.proxyFactory);
                        monitorAttributesFactory.addCacheListener(managementCacheListener);
                        RegionAttributes monitoringRegionAttrs = monitorAttributesFactory.create();
                        AttributesFactory<NotificationKey, Notification> notificationAttributesFactory = new AttributesFactory<NotificationKey, Notification>();
                        notificationAttributesFactory.setScope(Scope.DISTRIBUTED_NO_ACK);
                        notificationAttributesFactory.setDataPolicy(DataPolicy.REPLICATE);
                        notificationAttributesFactory.setConcurrencyChecksEnabled(false);
                        notificationAttributesFactory.setEvictionAttributes(EvictionAttributes.createLRUEntryAttributes(10, EvictionAction.LOCAL_DESTROY));
                        NotificationCacheListener notifListener = new NotificationCacheListener(FederatingManager.this.proxyFactory);
                        notificationAttributesFactory.addCacheListener(notifListener);
                        RegionAttributes notifRegionAttrs = notificationAttributesFactory.create();
                        try {
                            if (!FederatingManager.this.running) {
                                return null;
                            }
                            proxyMonitoringRegion = FederatingManager.this.cache.createInternalRegion(monitoringRegionName, monitoringRegionAttrs, internalRegionArguments);
                            proxyMonitoringRegionCreated = true;
                        }
                        catch (IOException | ClassNotFoundException | RegionExistsException | TimeoutException e) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("Error During Internal Region creation", (Throwable)e);
                            }
                            throw new ManagementException(e);
                        }
                        boolean proxyNotificationRegionCreated = false;
                        try {
                            if (!FederatingManager.this.running) {
                                DistributedMember distributedMember2 = null;
                                return distributedMember2;
                            }
                            proxyNotificationRegion = FederatingManager.this.cache.createInternalRegion(notificationRegionName, notifRegionAttrs, internalRegionArguments);
                            proxyNotificationRegionCreated = true;
                        }
                        catch (IOException | ClassNotFoundException | RegionExistsException | TimeoutException e) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("Error During Internal Region creation", (Throwable)e);
                            }
                            throw new ManagementException(e);
                        }
                        finally {
                            if (!proxyNotificationRegionCreated && proxyMonitoringRegionCreated) {
                                proxyMonitoringRegion.localDestroyRegion();
                            }
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug("Management Region created with Name : {}", (Object)proxyMonitoringRegion.getName());
                            logger.debug("Notification Region created with Name : {}", (Object)proxyNotificationRegion.getName());
                        }
                        FederatingManager.this.repo.putEntryInMonitoringRegionMap(this.member, proxyMonitoringRegion);
                        FederatingManager.this.repo.putEntryInNotifRegionMap(this.member, proxyNotificationRegion);
                        try {
                            if (!FederatingManager.this.running) {
                                return null;
                            }
                            FederatingManager.this.proxyFactory.createAllProxies(this.member, proxyMonitoringRegion);
                            managementCacheListener.markReady();
                            notifListener.markReady();
                        }
                        catch (Exception e) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("Error During GII Proxy creation", (Throwable)e);
                            }
                            throw new ManagementException(e);
                        }
                    }
                    catch (Exception e) {
                        throw new ManagementException(e);
                    }
                }
                FederatingManager.this.service.memberJoined((InternalDistributedMember)this.member);
                FederatingManager.this.messenger.sendManagerInfo(this.member);
                return this.member;
            }
        }
    }

    private class RemoveMemberTask
    implements Runnable {
        private final DistributedMember member;
        boolean crashed;

        RemoveMemberTask(DistributedMember member, boolean crashed) {
            this.member = member;
            this.crashed = crashed;
        }

        @Override
        public void run() {
            FederatingManager.this.removeMemberArtifacts(this.member, this.crashed);
        }
    }
}

