/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal;

import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public class AgentUtil {
    private static final Logger logger = LogService.getLogger();
    private final String gemfireVersion;
    private static final String GEODE_HOME = "GEODE_HOME";

    public AgentUtil(String gemfireVersion) {
        this.gemfireVersion = gemfireVersion;
    }

    public String findWarLocation(String warFilePrefix) {
        String unversionedWarFileName;
        String versionedWarFileName = warFilePrefix + "-" + this.gemfireVersion + ".war";
        String possiblePath = this.lookupWarLocationFromClasspath(versionedWarFileName, unversionedWarFileName = warFilePrefix + ".war");
        if (possiblePath != null) {
            logger.info("Located war: {} at location: {}", (Object)warFilePrefix, (Object)possiblePath);
            return possiblePath;
        }
        possiblePath = this.findPossibleWarLocationFromGeodeHome(versionedWarFileName, unversionedWarFileName);
        if (possiblePath != null) {
            logger.info("Located war: {} at location: {}", (Object)warFilePrefix, (Object)possiblePath);
            return possiblePath;
        }
        possiblePath = this.findPossibleWarLocationFromExtraLocations(versionedWarFileName, unversionedWarFileName);
        if (possiblePath != null) {
            logger.info("Located war: {} at location: {}", (Object)warFilePrefix, (Object)possiblePath);
            return possiblePath;
        }
        logger.warn(warFilePrefix + " war file was not found");
        return null;
    }

    private String findPossibleWarLocationFromExtraLocations(String versionedWarFileName, String unversionedWarFileName) {
        URL url = Arrays.stream(new String[]{versionedWarFileName, "tools/Pulse/" + versionedWarFileName, "tools/Extensions/" + versionedWarFileName, "lib/" + versionedWarFileName, unversionedWarFileName}).map(possibleFile -> this.getClass().getClassLoader().getResource((String)possibleFile)).filter(Objects::nonNull).findFirst().orElse(null);
        if (url != null) {
            String path = url.getPath();
            logger.info("War file found: {}", (Object)path);
            return path;
        }
        return null;
    }

    private String findPossibleWarLocationFromGeodeHome(String versionedWarFileName, String unversionedWarFileName) {
        String[] possibleFiles = new String[]{};
        String geodeHome = this.getGeodeHome();
        if (StringUtils.isNotBlank((CharSequence)geodeHome)) {
            possibleFiles = new String[]{geodeHome + "/tools/Extensions/" + versionedWarFileName, geodeHome + "/tools/Pulse/" + versionedWarFileName, geodeHome + "/lib/" + versionedWarFileName, geodeHome + "/tools/Extensions/" + unversionedWarFileName, geodeHome + "/tools/Pulse/" + unversionedWarFileName, geodeHome + "/lib/" + unversionedWarFileName};
        }
        return this.findPossibleWarLocationFromStream(Arrays.stream(possibleFiles));
    }

    private String findPossibleWarLocationFromStream(Stream<String> stream) {
        return stream.filter(possiblePath -> new File((String)possiblePath).isFile()).findFirst().orElse(null);
    }

    private String lookupWarLocationFromClasspath(String versionedWarFileName, String unversionedWarFileName) {
        return Arrays.stream(System.getProperty("java.class.path").split(File.pathSeparator)).filter(pathString -> pathString.endsWith(versionedWarFileName) || pathString.endsWith(unversionedWarFileName)).findFirst().orElse(null);
    }

    boolean isAnyWarFileAvailable(String ... warFileLocations) {
        for (String warFileLocation : warFileLocations) {
            if (!StringUtils.isNotBlank((CharSequence)warFileLocation)) continue;
            return true;
        }
        return false;
    }

    private String getGeodeHome() {
        String geodeHome = System.getenv(GEODE_HOME);
        logger.info("GEODE_HOME:" + geodeHome);
        if (StringUtils.isBlank((CharSequence)geodeHome)) {
            geodeHome = System.getProperty("gemfire.home");
            logger.info("Reading gemfire.home System Property -> {}", (Object)geodeHome);
            if (StringUtils.isBlank((CharSequence)geodeHome)) {
                logger.info("GEODE_HOME environment variable not set; HTTP service will not start.");
                geodeHome = null;
            }
        }
        return geodeHome;
    }

    public boolean isGemfireHomeDefined() {
        String gemfireHome = this.getGeodeHome();
        return StringUtils.isNotBlank((CharSequence)gemfireHome);
    }
}

