/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.util.concurrent;

import java.util.concurrent.CancellationException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.geode.CancelCriterion;
import org.apache.geode.internal.util.concurrent.StoppableCountDownLatch;

public class FutureResult
implements Future {
    private final StoppableCountDownLatch latch;
    private Object value;
    private volatile boolean isCancelled = false;

    public FutureResult(CancelCriterion crit) {
        this.latch = new StoppableCountDownLatch(crit, 1);
    }

    public FutureResult(Object value) {
        this.value = value;
        this.latch = null;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.isCancelled) {
            return false;
        }
        this.isCancelled = true;
        if (this.latch != null) {
            this.latch.countDown();
        }
        return true;
    }

    public Object get() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (this.isCancelled) {
            throw new CancellationException("Future was cancelled");
        }
        if (this.latch != null) {
            this.latch.await();
        }
        if (this.isCancelled) {
            throw new CancellationException("Future was cancelled");
        }
        return this.value;
    }

    public Object get(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (this.isCancelled) {
            throw new CancellationException("Future was cancelled");
        }
        if (this.latch != null && !this.latch.await(unit.toMillis(timeout))) {
            throw new TimeoutException();
        }
        return this.value;
    }

    @Override
    public boolean isCancelled() {
        return this.isCancelled;
    }

    @Override
    public boolean isDone() {
        return this.latch == null || this.latch.getCount() == 0L || this.isCancelled;
    }

    public void set(Object value) {
        this.value = value;
        if (this.latch != null) {
            this.latch.countDown();
        }
    }
}

