/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.util;

import java.io.IOException;
import java.util.Arrays;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.internal.DSCODE;

public class DscodeHelper {
    @Immutable
    private static final DSCODE[] dscodes = new DSCODE[128];

    public static DSCODE toDSCODE(byte value) throws IOException {
        try {
            return dscodes[value];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IOException("Unknown header byte: " + value);
        }
    }

    static {
        Arrays.stream(DSCODE.values()).filter(dscode -> dscode.toByte() >= 0).forEach(dscode -> {
            DscodeHelper.dscodes[dscode.toByte()] = dscode;
        });
    }
}

