/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.statistics.platform;

import org.apache.geode.StatisticDescriptor;
import org.apache.geode.StatisticsType;
import org.apache.geode.StatisticsTypeFactory;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.statistics.StatisticsTypeFactoryImpl;

public class SolarisSystemStats {
    private static final int allocatedSwapINT = 0;
    private static final int cpuActiveINT = 1;
    private static final int cpuIdleINT = 2;
    private static final int cpuIoWaitINT = 3;
    private static final int cpuSwapWaitINT = 4;
    private static final int cpuSystemINT = 5;
    private static final int cpuUserINT = 6;
    private static final int cpuWaitingINT = 7;
    private static final int cpusINT = 8;
    private static final int freeMemoryINT = 9;
    private static final int physicalMemoryINT = 10;
    private static final int processesINT = 11;
    private static final int reservedSwapINT = 12;
    private static final int schedulerRunCountINT = 13;
    private static final int schedulerSwapCountINT = 14;
    private static final int schedulerWaitCountINT = 15;
    private static final int unreservedSwapINT = 16;
    private static final int unallocatedSwapINT = 17;
    private static final int anonymousPagesFreedLONG = 0;
    private static final int anonymousPagesPagedInLONG = 1;
    private static final int anonymousPagesPagedOutLONG = 2;
    private static final int contextSwitchesLONG = 3;
    private static final int execPagesFreedLONG = 4;
    private static final int execPagesPagedInLONG = 5;
    private static final int execPagesPagedOutLONG = 6;
    private static final int failedMutexEntersLONG = 7;
    private static final int failedReaderLocksLONG = 8;
    private static final int failedWriterLocksLONG = 9;
    private static final int fileSystemPagesFreedLONG = 10;
    private static final int fileSystemPagesPagedInLONG = 11;
    private static final int fileSystemPagesPagedOutLONG = 12;
    private static final int hatMinorFaultsLONG = 13;
    private static final int interruptsLONG = 14;
    private static final int involContextSwitchesLONG = 15;
    private static final int majorPageFaultsLONG = 16;
    private static final int messageCountLONG = 17;
    private static final int pageDaemonCyclesLONG = 18;
    private static final int pageInsLONG = 19;
    private static final int pageOutsLONG = 20;
    private static final int pagerRunsLONG = 21;
    private static final int pagesPagedInLONG = 22;
    private static final int pagesPagedOutLONG = 23;
    private static final int pagesScannedLONG = 24;
    private static final int procsInIoWaitLONG = 25;
    private static final int protectionFaultsLONG = 26;
    private static final int semphoreOpsLONG = 27;
    private static final int softwareLockFaultsLONG = 28;
    private static final int systemCallsLONG = 29;
    private static final int systemMinorFaultsLONG = 30;
    private static final int threadCreatesLONG = 31;
    private static final int trapsLONG = 32;
    private static final int userMinorFaultsLONG = 33;
    private static final int loopbackInputPacketsLONG = 34;
    private static final int loopbackOutputPacketsLONG = 35;
    private static final int inputPacketsLONG = 36;
    private static final int inputErrorsLONG = 37;
    private static final int outputPacketsLONG = 38;
    private static final int outputErrorsLONG = 39;
    private static final int collisionsLONG = 40;
    private static final int inputBytesLONG = 41;
    private static final int outputBytesLONG = 42;
    private static final int multicastInputPacketsLONG = 43;
    private static final int multicastOutputPacketsLONG = 44;
    private static final int broadcastInputPacketsLONG = 45;
    private static final int broadcastOutputPacketsLONG = 46;
    private static final int inputPacketsDiscardedLONG = 47;
    private static final int outputPacketsDiscardedLONG = 48;
    private static final int loadAverage1DOUBLE = 0;
    private static final int loadAverage15DOUBLE = 1;
    private static final int loadAverage5DOUBLE = 2;
    @Immutable
    private static final StatisticsType myType;

    private static void checkOffset(String name, int offset) {
        int id = myType.nameToId(name);
        Assert.assertTrue(offset == id, "Expected the offset for " + name + " to be " + offset + " but it was " + id);
    }

    private SolarisSystemStats() {
    }

    public static StatisticsType getType() {
        return myType;
    }

    static {
        StatisticsTypeFactory f = StatisticsTypeFactoryImpl.singleton();
        myType = f.createType("SolarisSystemStats", "Statistics on a Solaris machine.", new StatisticDescriptor[]{f.createIntGauge("allocatedSwap", "The number of megabytes of swap space have actually been written to. Swap space must be reserved before it can be allocated.", "megabytes"), f.createIntGauge("cpuActive", "The percentage of the total available time that has been used to execute user or system code.", "%"), f.createIntGauge("cpuIdle", "The percentage of the total available time that has been spent sleeping.", "%", true), f.createIntGauge("cpuIoWait", "The percentage of the total available time that has been spent waiting for disk io to complete.", "%"), f.createIntGauge("cpuSwapWait", "The percentage of the total available time that has been spent waiting for paging and swapping to complete.", "%"), f.createIntGauge("cpuSystem", "The percentage of the total available time that has been used to execute system (i.e. kernel) code.", "%"), f.createIntGauge("cpuUser", "The percentage of the total available time that has been used to execute user code.", "%"), f.createIntGauge("cpuWaiting", "The percentage of the total available time that has been spent waiting for io, paging, or swapping.", "%"), f.createIntGauge("cpus", "The number of online cpus on the local machine.", "items"), f.createIntGauge("freeMemory", "The number of megabytes of unused memory on the machine.", "megabytes", true), f.createIntGauge("physicalMemory", "The actual amount of total physical memory on the machine.", "megabytes", true), f.createIntGauge("processes", "The number of processes in the computer at the time of data collection.  Notice that this is an instantaneous count, not an average over the time interval.  Each process represents the running of a program.", "processes"), f.createIntGauge("reservedSwap", "The number of megabytes of swap space reserved for allocation by a particular process.", "megabytes"), f.createIntCounter("schedulerRunCount", "The total number of times the system scheduler has put a thread in its run queue.", "operations", false), f.createIntCounter("schedulerSwapCount", "The total number of times the system scheduler has swapped out an idle process.", "operations", false), f.createIntCounter("schedulerWaitCount", "The total number of times the system scheduler has removed a thread from the run queue because it was waiting for a resource.", "operations", false), f.createIntGauge("unreservedSwap", "The number of megabytes of swap space that are free. If this value goes to zero new processes can no longer be created.", "megabytes", true), f.createIntGauge("unallocatedSwap", "The number of megabytes of swap space that have not been allocated.", "megabytes", true), f.createLongCounter("anonymousPagesFreed", "The total number pages that contain heap, stack, or other changeable data that have been removed from memory and added to the free list.", "pages"), f.createLongCounter("anonymousPagesPagedIn", "The total number pages that contain heap, stack, or other changeable data that have been allocated in memory and possibly copied from disk.", "pages", false), f.createLongCounter("anonymousPagesPagedOut", "The total number pages that contain heap, stack, or other changeable data that have been removed from memory and copied to disk.", "pages", false), f.createLongCounter("contextSwitches", "The total number of context switches from one thread to another on the computer.  Thread switches can occur either inside of a single process or across processes.  A thread switch may be caused either by one thread asking another for information, or by a thread being preempted by another, higher priority thread becoming ready to run.", "operations", false), f.createLongCounter("execPagesFreed", "The total number readonly pages that contain code or data that have been removed from memory and returned to the free list.", "pages"), f.createLongCounter("execPagesPagedIn", "The total number readonly pages that contain code or data that have been copied from disk to memory.", "pages", false), f.createLongCounter("execPagesPagedOut", "The total number readonly pages that contain code or data that have been removed from memory and will need to be paged in when used again.", "pages", false), f.createLongCounter("failedMutexEnters", "The total number of times a thread entering a mutex had to wait for the mutex to be unlocked.", "operations", false), f.createLongCounter("failedReaderLocks", "The total number of times readers failed to obtain a readers/writer locks on their first try. When this happens the reader has to wait for the current writer to release the lock.", "operations", false), f.createLongCounter("failedWriterLocks", "The total number of times writers failed to obtain a readers/writer locks on their first try. When this happens the writer has to wait for all the current readers or the single writer to release the lock.", "operations", false), f.createLongCounter("fileSystemPagesFreed", "The total number of pages, that contained the contents of a file due to the file being read from a file system, that   have been removed from memory and put on the free list.", "pages"), f.createLongCounter("fileSystemPagesPagedIn", "The total number of pages that contain the contents of a file due to the file being read from a file system.", "pages", false), f.createLongCounter("fileSystemPagesPagedOut", "The total number of pages, that contained the contents of a file due to the file being read from a file system, that   have been removed from memory and copied to disk.", "pages", false), f.createLongCounter("hatMinorFaults", "The total number of hat faults. You only get these on systems with software memory management units.", "operations", false), f.createLongCounter("interrupts", "The total number of interrupts that have occurred on the computer.", "operations", false), f.createLongCounter("involContextSwitches", "The total number of times a thread was forced to give up the cpu even though it was still ready to run.", "operations", false), f.createLongCounter("majorPageFaults", "The total number of times a page fault required disk io to get the page", "operations", false), f.createLongCounter("messageCount", "The total number of msgrcv() and msgsnd() system calls.", "messages"), f.createLongCounter("pageDaemonCycles", "The total number of revolutions of the page daemon's scan \"clock hand\".", "operations", false), f.createLongCounter("pageIns", "The total number of times pages have been brought into memory from disk by the operating system's memory manager.", "operations", false), f.createLongCounter("pageOuts", "The total number of times pages have been flushed from memory to disk by the operating system's memory manager.", "operations", false), f.createLongCounter("pagerRuns", "The total number of times the pager daemon has been scheduled to run.", "operations", false), f.createLongCounter("pagesPagedIn", "The total number of pages that have been brought into memory from disk by the operating system's memory manager.", "pages", false), f.createLongCounter("pagesPagedOut", "The total number of pages that have been flushed from memory to disk by the operating system's memory manager.", "pages", false), f.createLongCounter("pagesScanned", "The total number pages examined by the pageout daemon. When the amount of free memory gets below a certain size, the daemon start to look for inactive memory pages to steal from processes. So I high scan rate is a good indication of needing more memory.", "pages", false), f.createLongGauge("procsInIoWait", "The number of processes waiting for block I/O at this instant in time.", "processes"), f.createLongCounter("protectionFaults", "The total number of times memory has been accessed in a way that was not allowed. This results in a segementation violation and in most cases a core dump.", "operations", false), f.createLongCounter("semphoreOps", "The total number of semaphore operations.", "operations"), f.createLongCounter("softwareLockFaults", "The total number of faults caused by software locks held on memory pages.", "operations", false), f.createLongCounter("systemCalls", "The total number system calls.", "operations"), f.createLongCounter("systemMinorFaults", "The total number of minor page faults in kernel code. Minor page faults do not require disk access.", "operations", false), f.createLongCounter("threadCreates", "The total number of times a thread has been created.", "operations", false), f.createLongCounter("traps", "The total number of traps that have occurred on the computer.", "operations", false), f.createLongCounter("userMinorFaults", "The total number of minor page faults in non-kernel code. Minor page faults do not require disk access.", "operatations", false), f.createLongCounter("loopbackInputPackets", "The total number of input packets received over the loopback network adaptor.", "packets"), f.createLongCounter("loopbackOutputPackets", "The total number of output packets sent over the loopback network adaptor.", "packets"), f.createLongCounter("inputPackets", "packets received (Solaris kstat 'ipackets')", "packets"), f.createLongCounter("inputErrors", "input errors (Solaris kstat 'ierrors')", "errors", false), f.createLongCounter("outputPackets", "Solaris kstat 'opackets'", "packets"), f.createLongCounter("outputErrors", "output errors (Solaris kstat 'oerrors')", "errors", false), f.createLongCounter("collisions", "Solaris kstat 'collisions'", "collisions", false), f.createLongCounter("inputBytes", "octets received (Solaris kstat 'rbytes')", "bytes"), f.createLongCounter("outputBytes", "octats transmitted (Solaris kstat 'obytes')", "bytes"), f.createLongCounter("multicastInputPackets", "multicast received (Solaris kstat 'multircv')", "packets"), f.createLongCounter("multicastOutputPackets", "multicast requested to be sent (Solaris kstat 'multixmt')", "packets"), f.createLongCounter("broadcastInputPackets", "broadcast received (Solaris kstat 'brdcstrcv')", "packets"), f.createLongCounter("broadcastOutputPackets", "broadcast requested to be sent (Solaris kstat 'brdcstxmt')", "packets"), f.createLongCounter("inputPacketsDiscarded", "number receive packets discarded (Solaris kstat 'norcvbuf')", "packets"), f.createLongCounter("outputPacketsDiscarded", "packets that could not be sent up because the queue was flow controlled (Solaris kstat 'noxmtbuf')", "packets"), f.createDoubleGauge("loadAverage1", "The average number of threads ready to run over the last minute.", "threads"), f.createDoubleGauge("loadAverage15", "The average number of threads ready to run over the last fifteen minutes.", "threads"), f.createDoubleGauge("loadAverage5", "The average number of threads ready to run over the last five minutes.", "threads")});
        SolarisSystemStats.checkOffset("allocatedSwap", 0);
        SolarisSystemStats.checkOffset("cpuActive", 1);
        SolarisSystemStats.checkOffset("cpuIdle", 2);
        SolarisSystemStats.checkOffset("cpuIoWait", 3);
        SolarisSystemStats.checkOffset("cpuSwapWait", 4);
        SolarisSystemStats.checkOffset("cpuSystem", 5);
        SolarisSystemStats.checkOffset("cpuUser", 6);
        SolarisSystemStats.checkOffset("cpuWaiting", 7);
        SolarisSystemStats.checkOffset("cpus", 8);
        SolarisSystemStats.checkOffset("freeMemory", 9);
        SolarisSystemStats.checkOffset("physicalMemory", 10);
        SolarisSystemStats.checkOffset("processes", 11);
        SolarisSystemStats.checkOffset("reservedSwap", 12);
        SolarisSystemStats.checkOffset("schedulerRunCount", 13);
        SolarisSystemStats.checkOffset("schedulerSwapCount", 14);
        SolarisSystemStats.checkOffset("schedulerWaitCount", 15);
        SolarisSystemStats.checkOffset("unreservedSwap", 16);
        SolarisSystemStats.checkOffset("unallocatedSwap", 17);
        SolarisSystemStats.checkOffset("anonymousPagesFreed", 0);
        SolarisSystemStats.checkOffset("anonymousPagesPagedIn", 1);
        SolarisSystemStats.checkOffset("anonymousPagesPagedOut", 2);
        SolarisSystemStats.checkOffset("contextSwitches", 3);
        SolarisSystemStats.checkOffset("execPagesFreed", 4);
        SolarisSystemStats.checkOffset("execPagesPagedIn", 5);
        SolarisSystemStats.checkOffset("execPagesPagedOut", 6);
        SolarisSystemStats.checkOffset("failedMutexEnters", 7);
        SolarisSystemStats.checkOffset("failedReaderLocks", 8);
        SolarisSystemStats.checkOffset("failedWriterLocks", 9);
        SolarisSystemStats.checkOffset("fileSystemPagesFreed", 10);
        SolarisSystemStats.checkOffset("fileSystemPagesPagedIn", 11);
        SolarisSystemStats.checkOffset("fileSystemPagesPagedOut", 12);
        SolarisSystemStats.checkOffset("hatMinorFaults", 13);
        SolarisSystemStats.checkOffset("interrupts", 14);
        SolarisSystemStats.checkOffset("involContextSwitches", 15);
        SolarisSystemStats.checkOffset("majorPageFaults", 16);
        SolarisSystemStats.checkOffset("messageCount", 17);
        SolarisSystemStats.checkOffset("pageDaemonCycles", 18);
        SolarisSystemStats.checkOffset("pageIns", 19);
        SolarisSystemStats.checkOffset("pageOuts", 20);
        SolarisSystemStats.checkOffset("pagerRuns", 21);
        SolarisSystemStats.checkOffset("pagesPagedIn", 22);
        SolarisSystemStats.checkOffset("pagesPagedOut", 23);
        SolarisSystemStats.checkOffset("pagesScanned", 24);
        SolarisSystemStats.checkOffset("procsInIoWait", 25);
        SolarisSystemStats.checkOffset("protectionFaults", 26);
        SolarisSystemStats.checkOffset("semphoreOps", 27);
        SolarisSystemStats.checkOffset("softwareLockFaults", 28);
        SolarisSystemStats.checkOffset("systemCalls", 29);
        SolarisSystemStats.checkOffset("systemMinorFaults", 30);
        SolarisSystemStats.checkOffset("threadCreates", 31);
        SolarisSystemStats.checkOffset("traps", 32);
        SolarisSystemStats.checkOffset("userMinorFaults", 33);
        SolarisSystemStats.checkOffset("loopbackInputPackets", 34);
        SolarisSystemStats.checkOffset("loopbackOutputPackets", 35);
        SolarisSystemStats.checkOffset("inputPackets", 36);
        SolarisSystemStats.checkOffset("inputErrors", 37);
        SolarisSystemStats.checkOffset("outputPackets", 38);
        SolarisSystemStats.checkOffset("outputErrors", 39);
        SolarisSystemStats.checkOffset("collisions", 40);
        SolarisSystemStats.checkOffset("inputBytes", 41);
        SolarisSystemStats.checkOffset("outputBytes", 42);
        SolarisSystemStats.checkOffset("multicastInputPackets", 43);
        SolarisSystemStats.checkOffset("multicastOutputPackets", 44);
        SolarisSystemStats.checkOffset("broadcastInputPackets", 45);
        SolarisSystemStats.checkOffset("broadcastOutputPackets", 46);
        SolarisSystemStats.checkOffset("inputPacketsDiscarded", 47);
        SolarisSystemStats.checkOffset("outputPacketsDiscarded", 48);
        SolarisSystemStats.checkOffset("loadAverage1", 0);
        SolarisSystemStats.checkOffset("loadAverage15", 1);
        SolarisSystemStats.checkOffset("loadAverage5", 2);
    }
}

