/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.statistics.platform;

import org.apache.geode.StatisticDescriptor;
import org.apache.geode.StatisticsType;
import org.apache.geode.StatisticsTypeFactory;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.statistics.StatisticsTypeFactoryImpl;

public class OSXSystemStats {
    @Immutable
    private static final StatisticsType myType;

    private static void checkOffset(String name, int offset) {
        int id = myType.nameToId(name);
        Assert.assertTrue(offset == id, "Expected the offset for " + name + " to be " + offset + " but it was " + id);
    }

    private OSXSystemStats() {
    }

    public static StatisticsType getType() {
        return myType;
    }

    static {
        StatisticsTypeFactory f = StatisticsTypeFactoryImpl.singleton();
        myType = f.createType("OSXSystemStats", "Statistics on an OS X machine.", new StatisticDescriptor[]{f.createIntGauge("dummyStat", "Place holder statistic until Stats are implimented for the Mac OS X Platform.", "megabytes")});
    }
}

