/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.statistics.platform;

import org.apache.geode.StatisticDescriptor;
import org.apache.geode.Statistics;
import org.apache.geode.StatisticsType;
import org.apache.geode.StatisticsTypeFactory;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.statistics.HostStatHelper;
import org.apache.geode.internal.statistics.LocalStatisticsImpl;
import org.apache.geode.internal.statistics.StatisticsTypeFactoryImpl;
import org.apache.geode.internal.statistics.platform.ProcessStats;

public class OSXProcessStats {
    @MakeNotStatic
    private static final StatisticsType myType;

    private static void checkOffset(String name, int offset) {
        int id = myType.nameToId(name);
        Assert.assertTrue(offset == id, "Expected the offset for " + name + " to be " + offset + " but it was " + id);
    }

    private OSXProcessStats() {
    }

    public static StatisticsType getType() {
        return myType;
    }

    public static ProcessStats createProcessStats(Statistics stats) {
        if (stats instanceof LocalStatisticsImpl) {
            HostStatHelper.refresh((LocalStatisticsImpl)stats);
        }
        return new ProcessStats(stats){

            @Override
            public long getProcessSize() {
                return 0L;
            }
        };
    }

    static {
        StatisticsTypeFactory f = StatisticsTypeFactoryImpl.singleton();
        myType = f.createType("OSXProcessStats", "Statistics on a OS X process.", new StatisticDescriptor[]{f.createIntGauge("dummyStat", "Placeholder", "megabytes")});
    }
}

