/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.statistics;

import java.util.concurrent.atomic.DoubleAdder;
import java.util.concurrent.atomic.LongAdder;
import java.util.stream.Stream;
import org.apache.geode.StatisticsType;
import org.apache.geode.internal.statistics.StatisticsImpl;
import org.apache.geode.internal.statistics.StatisticsManager;
import org.apache.geode.internal.statistics.StatisticsTypeImpl;

public class StripedStatisticsImpl
extends StatisticsImpl {
    private final LongAdder[] intAdders;
    private final LongAdder[] longAdders;
    private final DoubleAdder[] doubleAdders;

    public StripedStatisticsImpl(StatisticsType type, String textId, long numericId, long uniqueId, StatisticsManager statisticsManager) {
        super(type, textId, numericId, uniqueId, 0, statisticsManager);
        StatisticsTypeImpl realType = (StatisticsTypeImpl)type;
        this.intAdders = (LongAdder[])Stream.generate(LongAdder::new).limit(realType.getIntStatCount()).toArray(LongAdder[]::new);
        this.longAdders = (LongAdder[])Stream.generate(LongAdder::new).limit(realType.getLongStatCount()).toArray(LongAdder[]::new);
        this.doubleAdders = (DoubleAdder[])Stream.generate(DoubleAdder::new).limit(realType.getDoubleStatCount()).toArray(DoubleAdder[]::new);
    }

    @Override
    public boolean isAtomic() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _setInt(int offset, int value) {
        LongAdder longAdder = this.intAdders[offset];
        synchronized (longAdder) {
            this.intAdders[offset].reset();
            this.intAdders[offset].add(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _setLong(int offset, long value) {
        LongAdder longAdder = this.longAdders[offset];
        synchronized (longAdder) {
            this.longAdders[offset].reset();
            this.longAdders[offset].add(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _setDouble(int offset, double value) {
        DoubleAdder doubleAdder = this.doubleAdders[offset];
        synchronized (doubleAdder) {
            this.doubleAdders[offset].reset();
            this.doubleAdders[offset].add(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int _getInt(int offset) {
        LongAdder longAdder = this.intAdders[offset];
        synchronized (longAdder) {
            return this.intAdders[offset].intValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long _getLong(int offset) {
        LongAdder longAdder = this.longAdders[offset];
        synchronized (longAdder) {
            return this.longAdders[offset].sum();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected double _getDouble(int offset) {
        DoubleAdder doubleAdder = this.doubleAdders[offset];
        synchronized (doubleAdder) {
            return this.doubleAdders[offset].sum();
        }
    }

    @Override
    protected void _incInt(int offset, int delta) {
        this.intAdders[offset].add(delta);
    }

    @Override
    protected void _incLong(int offset, long delta) {
        this.longAdders[offset].add(delta);
    }

    @Override
    protected void _incDouble(int offset, double delta) {
        this.doubleAdders[offset].add(delta);
    }
}

