/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.statistics;

import java.io.File;
import org.apache.geode.CancelCriterion;
import org.apache.geode.internal.NanoTimer;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.internal.statistics.HostStatSampler;
import org.apache.geode.internal.statistics.StatSamplerStats;
import org.apache.geode.internal.statistics.StatisticsManager;
import org.apache.logging.log4j.Logger;

public class SimpleStatSampler
extends HostStatSampler {
    private static final Logger logger = LogService.getLogger();
    public static final String ARCHIVE_FILE_NAME_PROPERTY = "stats.archive-file";
    public static final String FILE_SIZE_LIMIT_PROPERTY = "stats.file-size-limit";
    public static final String DISK_SPACE_LIMIT_PROPERTY = "stats.disk-space-limit";
    public static final String SAMPLE_RATE_PROPERTY = "stats.sample-rate";
    public static final String DEFAULT_ARCHIVE_FILE_NAME = "stats.gfs";
    public static final long DEFAULT_FILE_SIZE_LIMIT = 0L;
    public static final long DEFAULT_DISK_SPACE_LIMIT = 0L;
    public static final int DEFAULT_SAMPLE_RATE = 1000;
    private final File archiveFileName = new File(System.getProperty("stats.archive-file", "stats.gfs"));
    private final long archiveFileSizeLimit = Long.getLong("stats.file-size-limit", 0L) * 0x100000L;
    private final long archiveDiskSpaceLimit = Long.getLong("stats.disk-space-limit", 0L) * 0x100000L;
    private final int sampleRate = Integer.getInteger("stats.sample-rate", 1000);
    private final StatisticsManager sm;

    public SimpleStatSampler(CancelCriterion stopper, StatisticsManager sm) {
        this(stopper, sm, new NanoTimer());
    }

    public SimpleStatSampler(CancelCriterion stopper, StatisticsManager sm, NanoTimer timer) {
        super(stopper, new StatSamplerStats(sm, 0L), timer);
        this.sm = sm;
        logger.info(LogMarker.STATISTICS_MARKER, "stats.sample-rate={}", (Object)this.getSampleRate());
    }

    @Override
    protected void checkListeners() {
    }

    @Override
    public File getArchiveFileName() {
        return this.archiveFileName;
    }

    @Override
    public long getArchiveFileSizeLimit() {
        if (this.fileSizeLimitInKB()) {
            return this.archiveFileSizeLimit / 1024L;
        }
        return this.archiveFileSizeLimit;
    }

    @Override
    public long getArchiveDiskSpaceLimit() {
        if (this.fileSizeLimitInKB()) {
            return this.archiveDiskSpaceLimit / 1024L;
        }
        return this.archiveDiskSpaceLimit;
    }

    @Override
    public long getSystemId() {
        return 0L;
    }

    @Override
    public String getProductDescription() {
        return "Unknown product";
    }

    @Override
    protected StatisticsManager getStatisticsManager() {
        return this.sm;
    }

    @Override
    protected int getSampleRate() {
        return this.sampleRate;
    }

    @Override
    public boolean isSamplingEnabled() {
        return true;
    }
}

