/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.statistics;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.geode.InternalGemFireException;
import org.apache.geode.Statistics;
import org.apache.geode.internal.PureJavaMode;
import org.apache.geode.internal.net.SocketCreator;
import org.apache.geode.internal.statistics.LocalStatisticsImpl;
import org.apache.geode.internal.statistics.platform.LinuxProcFsStatistics;
import org.apache.geode.internal.statistics.platform.LinuxProcessStats;
import org.apache.geode.internal.statistics.platform.LinuxSystemStats;
import org.apache.geode.internal.statistics.platform.OSXProcessStats;
import org.apache.geode.internal.statistics.platform.OSXSystemStats;
import org.apache.geode.internal.statistics.platform.OsStatisticsFactory;
import org.apache.geode.internal.statistics.platform.ProcessStats;
import org.apache.geode.internal.statistics.platform.SolarisProcessStats;
import org.apache.geode.internal.statistics.platform.SolarisSystemStats;
import org.apache.geode.internal.statistics.platform.WindowsProcessStats;
import org.apache.geode.internal.statistics.platform.WindowsSystemStats;

public class HostStatHelper {
    private static final int SOLARIS_CODE = 1;
    private static final int WINDOWS_CODE = 2;
    private static final int LINUX_CODE = 3;
    private static final int OSX_CODE = 4;
    private static final int PROCESS_STAT_FLAG = 1;
    private static final int SYSTEM_STAT_FLAG = 2;
    private static final int osCode;

    public static boolean isWindows() {
        return osCode == 2;
    }

    public static boolean isUnix() {
        return osCode != 2;
    }

    public static boolean isSolaris() {
        return osCode == 1;
    }

    public static boolean isLinux() {
        return osCode == 3;
    }

    public static boolean isOSX() {
        return osCode == 4;
    }

    private HostStatHelper() {
    }

    static int initOSStats() {
        if (HostStatHelper.isLinux()) {
            return LinuxProcFsStatistics.init();
        }
        return HostStatHelper.init();
    }

    static void closeOSStats() {
        if (HostStatHelper.isLinux()) {
            LinuxProcFsStatistics.close();
        } else {
            HostStatHelper.close();
        }
    }

    static void readyRefreshOSStats() {
        if (HostStatHelper.isLinux()) {
            LinuxProcFsStatistics.readyRefresh();
        } else {
            HostStatHelper.readyRefresh();
        }
    }

    private static native int init();

    private static native void close();

    private static native void readyRefresh();

    private static void refreshProcess(LocalStatisticsImpl statistics) {
        int pid = (int)statistics.getNumericId();
        if (HostStatHelper.isLinux()) {
            LinuxProcFsStatistics.refreshProcess(pid, statistics._getIntStorage(), statistics._getLongStorage(), statistics._getDoubleStorage());
        } else {
            HostStatHelper.refreshProcess(pid, statistics._getIntStorage(), statistics._getLongStorage(), statistics._getDoubleStorage());
        }
    }

    private static native void refreshProcess(int var0, int[] var1, long[] var2, double[] var3);

    private static void refreshSystem(LocalStatisticsImpl statistics) {
        if (HostStatHelper.isLinux()) {
            LinuxProcFsStatistics.refreshSystem(statistics._getIntStorage(), statistics._getLongStorage(), statistics._getDoubleStorage());
        } else {
            HostStatHelper.refreshSystem(statistics._getIntStorage(), statistics._getLongStorage(), statistics._getDoubleStorage());
        }
    }

    private static native void refreshSystem(int[] var0, long[] var1, double[] var2);

    public static void refresh(LocalStatisticsImpl statistics) {
        int flags = statistics.getOsStatFlags();
        if ((flags & 1) != 0) {
            HostStatHelper.refreshProcess(statistics);
        } else if ((flags & 2) != 0) {
            HostStatHelper.refreshSystem(statistics);
        } else {
            throw new RuntimeException(String.format("Unexpected os stats flags %s", flags));
        }
    }

    static Statistics newProcess(OsStatisticsFactory osStatisticsFactory, long pid, String name) {
        Statistics statistics;
        switch (osCode) {
            case 1: {
                statistics = osStatisticsFactory.createOsStatistics(SolarisProcessStats.getType(), name, pid, 1);
                break;
            }
            case 3: {
                statistics = osStatisticsFactory.createOsStatistics(LinuxProcessStats.getType(), name, pid, 1);
                break;
            }
            case 4: {
                statistics = osStatisticsFactory.createOsStatistics(OSXProcessStats.getType(), name, pid, 1);
                break;
            }
            case 2: {
                statistics = osStatisticsFactory.createOsStatistics(WindowsProcessStats.getType(), name, pid, 1);
                break;
            }
            default: {
                throw new InternalGemFireException(String.format("unhandled osCode= %s HostStatHelper:newProcess", osCode));
            }
        }
        return statistics;
    }

    static ProcessStats newProcessStats(Statistics statistics) {
        switch (osCode) {
            case 1: {
                return SolarisProcessStats.createProcessStats(statistics);
            }
            case 3: {
                return LinuxProcessStats.createProcessStats(statistics);
            }
            case 2: {
                return WindowsProcessStats.createProcessStats(statistics);
            }
            case 4: {
                return OSXProcessStats.createProcessStats(statistics);
            }
        }
        throw new InternalGemFireException(String.format("unhandled osCode= %s HostStatHelper:newProcessStats", osCode));
    }

    static void newSystem(OsStatisticsFactory osStatisticsFactory, long id) {
        Statistics statistics;
        switch (osCode) {
            case 1: {
                statistics = osStatisticsFactory.createOsStatistics(SolarisSystemStats.getType(), HostStatHelper.getHostSystemName(), id, 2);
                break;
            }
            case 3: {
                statistics = osStatisticsFactory.createOsStatistics(LinuxSystemStats.getType(), HostStatHelper.getHostSystemName(), id, 2);
                break;
            }
            case 2: {
                statistics = osStatisticsFactory.createOsStatistics(WindowsSystemStats.getType(), HostStatHelper.getHostSystemName(), id, 2);
                break;
            }
            case 4: {
                statistics = osStatisticsFactory.createOsStatistics(OSXSystemStats.getType(), HostStatHelper.getHostSystemName(), id, 2);
                break;
            }
            default: {
                throw new InternalGemFireException(String.format("unhandled osCode= %s HostStatHelper:newSystem", osCode));
            }
        }
        if (statistics instanceof LocalStatisticsImpl) {
            HostStatHelper.refreshSystem((LocalStatisticsImpl)statistics);
        }
    }

    private static String getHostSystemName() {
        String hostname = "unknownHostName";
        try {
            InetAddress inetAddress = SocketCreator.getLocalHost();
            hostname = inetAddress.getCanonicalHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return hostname;
    }

    static {
        String osName = System.getProperty("os.name", "unknown");
        if (!PureJavaMode.osStatsAreAvailable()) {
            throw new RuntimeException("HostStatHelper not allowed in pure java mode");
        }
        if (osName.equals("SunOS")) {
            osCode = 1;
        } else if (osName.startsWith("Windows")) {
            osCode = 2;
        } else if (osName.startsWith("Linux")) {
            osCode = 3;
        } else if (osName.equals("Mac OS X")) {
            osCode = 4;
        } else {
            throw new InternalGemFireException(String.format("Unsupported OS %s. Supported OSs are: SunOS(sparc Solaris), Linux(x86) and Windows.", osName));
        }
    }
}

