/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.shared;

import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketImpl;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.geode.SystemFailure;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.internal.shared.NativeErrorException;
import org.apache.geode.internal.shared.OSType;
import org.apache.geode.internal.shared.TCPSocketOptions;

public abstract class NativeCalls {
    @Immutable
    protected static final NativeCalls instance;
    protected static final int OPT_IPPROTO_TCP = 6;
    protected static final int UNSUPPORTED_OPTION = Integer.MIN_VALUE;

    public static NativeCalls getInstance() {
        return instance;
    }

    protected int getSocketKernelDescriptor(Socket sock, InputStream sockStream) throws UnsupportedOperationException {
        Field f;
        FileDescriptor fd = null;
        try {
            f = NativeCalls.getAnyField(sock.getClass(), "self");
            if (f != null) {
                f.setAccessible(true);
                Object self = f.get(sock);
                if (self instanceof Socket) {
                    sock = (Socket)self;
                    sockStream = sock.getInputStream();
                }
            }
        }
        catch (NoSuchFieldException self) {
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception ex) {
            throw new UnsupportedOperationException(ex);
        }
        if (sockStream instanceof FileInputStream) {
            try {
                fd = ((FileInputStream)sockStream).getFD();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        try {
            if (fd == null) {
                Method m;
                block27: {
                    try {
                        m = NativeCalls.getAnyMethod(sock.getClass(), "getImpl", new Class[0]);
                    }
                    catch (Exception ex) {
                        try {
                            m = NativeCalls.getAnyMethod(sock.getClass(), "getPlainSocketImpl", new Class[0]);
                        }
                        catch (Exception e) {
                            m = null;
                            if (sockStream == null) {
                                sockStream = sock.getInputStream();
                                if (sockStream instanceof FileInputStream) {
                                    fd = ((FileInputStream)sockStream).getFD();
                                }
                                break block27;
                            }
                            throw e;
                        }
                    }
                }
                if (m != null) {
                    m.setAccessible(true);
                    SocketImpl sockImpl = (SocketImpl)m.invoke((Object)sock, new Object[0]);
                    if (sockImpl != null) {
                        try {
                            m = NativeCalls.getAnyMethod(sockImpl.getClass(), "getFileDescriptor", new Class[0]);
                            if (m != null) {
                                m.setAccessible(true);
                                fd = (FileDescriptor)m.invoke((Object)sockImpl, new Object[0]);
                            }
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            // empty catch block
                        }
                    }
                }
            }
            if (fd != null && (f = NativeCalls.getAnyField(fd.getClass(), "fd")) != null) {
                f.setAccessible(true);
                Object obj = f.get(fd);
                if (obj instanceof Integer) {
                    return (Integer)obj;
                }
            }
            throw new UnsupportedOperationException();
        }
        catch (SecurityException se) {
            throw new UnsupportedOperationException(se);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception ex) {
            throw new UnsupportedOperationException(ex);
        }
    }

    protected static Method getAnyMethod(Class<?> c, String name, Class<?> ... parameterTypes) throws NoSuchMethodException, SecurityException {
        NoSuchMethodException firstEx = null;
        while (true) {
            try {
                return c.getDeclaredMethod(name, parameterTypes);
            }
            catch (NoSuchMethodException nsme) {
                if (firstEx != null) continue;
                firstEx = nsme;
                if ((c = c.getSuperclass()) != null) continue;
                throw firstEx;
            }
            break;
        }
    }

    protected static Field getAnyField(Class<?> c, String name) throws NoSuchFieldException, SecurityException {
        NoSuchFieldException firstEx = null;
        while (true) {
            try {
                return c.getDeclaredField(name);
            }
            catch (NoSuchFieldException nsfe) {
                if (firstEx != null) continue;
                firstEx = nsfe;
                if ((c = c.getSuperclass()) != null) continue;
                throw firstEx;
            }
            break;
        }
    }

    protected String getUnsupportedSocketOptionMessage(TCPSocketOptions opt) {
        return "setSocketOption(): socket option " + (Object)((Object)opt) + " not supported by current platform " + (Object)((Object)this.getOSType());
    }

    public abstract OSType getOSType();

    public abstract String getEnvironment(String var1);

    public abstract int getProcessId();

    public abstract boolean isProcessActive(int var1) throws UnsupportedOperationException;

    public abstract boolean killProcess(int var1) throws UnsupportedOperationException;

    public void daemonize(RehashServerOnSIGHUP callback) throws UnsupportedOperationException, IllegalStateException {
        throw new UnsupportedOperationException("daemonize() not available in base implementation");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preBlow(String path, long maxSize, boolean preAllocate) throws IOException {
        try (RandomAccessFile raf = new RandomAccessFile(path, "rw");){
            raf.setLength(maxSize);
        }
    }

    public boolean isOnLocalFileSystem(String path) {
        return false;
    }

    public abstract Map<TCPSocketOptions, Throwable> setSocketOptions(Socket var1, InputStream var2, Map<TCPSocketOptions, Object> var3) throws UnsupportedOperationException;

    protected Map<TCPSocketOptions, Throwable> setGenericSocketOptions(Socket sock, InputStream sockStream, Map<TCPSocketOptions, Object> optValueMap) throws UnsupportedOperationException {
        Set<Map.Entry<TCPSocketOptions, Object>> optValueEntries = optValueMap.entrySet();
        for (Map.Entry<TCPSocketOptions, Object> e : optValueEntries) {
            TCPSocketOptions opt = e.getKey();
            Object value = e.getValue();
            this.getPlatformOption(opt);
            if (value != null && value instanceof Integer) continue;
            throw new IllegalArgumentException("bad argument type " + (value != null ? value.getClass().getName() : "NULL") + " for " + (Object)((Object)opt));
        }
        HashMap<TCPSocketOptions, Throwable> failures = new HashMap<TCPSocketOptions, Throwable>(4);
        int sockfd = this.getSocketKernelDescriptor(sock, sockStream);
        for (Map.Entry<TCPSocketOptions, Object> e : optValueEntries) {
            TCPSocketOptions opt = e.getKey();
            Object value = e.getValue();
            int optName = this.getPlatformOption(opt);
            if (optName == Integer.MIN_VALUE) {
                failures.put(opt, new UnsupportedOperationException(this.getUnsupportedSocketOptionMessage(opt)));
                continue;
            }
            int optSize = 4;
            try {
                if (this.setPlatformSocketOption(sockfd, 6, optName, opt, (Integer)value, 4) == 0) continue;
                failures.put(opt, new SocketException((Object)((Object)this.getOSType()) + ": error setting option " + (Object)((Object)opt) + " to " + value));
            }
            catch (NativeErrorException ne) {
                if (this.isNoProtocolOptionCode(ne.getErrorCode())) {
                    failures.put(opt, new UnsupportedOperationException(this.getUnsupportedSocketOptionMessage(opt), ne));
                    continue;
                }
                SocketException se = new SocketException((Object)((Object)this.getOSType()) + ": failed to set " + (Object)((Object)opt) + " to " + value);
                se.initCause(ne);
                failures.put(opt, se);
            }
        }
        return failures.size() > 0 ? failures : null;
    }

    protected int getPlatformOption(TCPSocketOptions opt) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("setSocketOption not supported for generic POSIX platform");
    }

    protected int setPlatformSocketOption(int sockfd, int level, int optName, TCPSocketOptions opt, Integer optVal, int optSize) throws UnsupportedOperationException, NativeErrorException {
        throw new UnsupportedOperationException("setSocketOption not supported for generic POSIX platform");
    }

    protected boolean isNoProtocolOptionCode(int errno) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("setSocketOption not supported for generic POSIX platform");
    }

    public boolean isNativeTimerEnabled() {
        return false;
    }

    public long nanoTime(int clock_id) {
        return System.nanoTime();
    }

    public long clockResolution(int clock_id) {
        return 0L;
    }

    public boolean isTTY() {
        return false;
    }

    static {
        NativeCalls inst;
        try {
            Class<?> c = Class.forName("org.apache.geode.internal.shared.NativeCallsJNAImpl");
            inst = (NativeCalls)c.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure(e);
            throw e;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            inst = null;
        }
        if (inst == null) {
            inst = new NativeCallsGeneric();
        }
        instance = inst;
    }

    public static class NativeCallsGeneric
    extends NativeCalls {
        private static final boolean isWin = System.getProperty("os.name").indexOf("Windows") >= 0;

        @Override
        public OSType getOSType() {
            return isWin ? OSType.WIN : OSType.GENERIC;
        }

        @Override
        public String getEnvironment(String name) {
            return System.getenv(name);
        }

        @Override
        public int getProcessId() {
            String name = ManagementFactory.getRuntimeMXBean().getName();
            int idx = name.indexOf(64);
            if (idx > 0) {
                try {
                    return Integer.parseInt(name.substring(0, idx));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return 0;
        }

        @Override
        public boolean isProcessActive(int processId) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("isProcessActive() not available in generic implementation");
        }

        @Override
        public boolean killProcess(int processId) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("killProcess() not available in generic implementation");
        }

        @Override
        public Map<TCPSocketOptions, Throwable> setSocketOptions(Socket sock, InputStream sockStream, Map<TCPSocketOptions, Object> optValueMap) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("setting native socket options " + optValueMap.keySet() + " not possible in generic implementation");
        }
    }

    public static interface RehashServerOnSIGHUP {
        public void rehash();
    }
}

