/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.sequencelog;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.EnumSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.internal.OSProcess;
import org.apache.geode.internal.sequencelog.GraphType;
import org.apache.geode.internal.sequencelog.SequenceLogger;
import org.apache.geode.internal.sequencelog.Transition;
import org.apache.geode.internal.sequencelog.io.OutputStreamAppender;

public class SequenceLoggerImpl
implements SequenceLogger {
    @Immutable
    private static final SequenceLoggerImpl INSTANCE;
    public static final String ENABLED_TYPES_PROPERTY = "gemfire.GraphLoggerImpl.ENABLED_TYPES";
    private final EnumSet<GraphType> enabledTypes;
    private final LinkedBlockingQueue<Transition> edges = new LinkedBlockingQueue();
    private volatile OutputStreamAppender appender;
    private ConsumerThread consumerThread;

    public static SequenceLogger getInstance() {
        return INSTANCE;
    }

    public static void signalCacheClose() {
        if (INSTANCE != null && SequenceLoggerImpl.INSTANCE.consumerThread != null) {
            SequenceLoggerImpl.INSTANCE.consumerThread.interrupt();
        }
    }

    @Override
    public boolean isEnabled(GraphType type) {
        return this.enabledTypes.contains((Object)type);
    }

    @Override
    public void logTransition(GraphType type, Object graphName, Object edgeName, Object state, Object source, Object dest) {
        if (this.isEnabled(type)) {
            Transition edge = new Transition(type, graphName, edgeName, state, source, dest);
            this.edges.add(edge);
        }
    }

    @Override
    public void flush() throws InterruptedException {
        FlushToken token = new FlushToken();
        this.edges.add(token);
        token.cdl.await();
    }

    private SequenceLoggerImpl() {
        String enabledTypesString = System.getProperty(ENABLED_TYPES_PROPERTY, "");
        this.enabledTypes = GraphType.parse(enabledTypesString);
        if (!this.enabledTypes.isEmpty()) {
            try {
                String name = "states" + OSProcess.getId() + ".graph";
                this.appender = new OutputStreamAppender(new File(name));
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
    }

    private void start() {
        if (!this.enabledTypes.isEmpty()) {
            this.consumerThread = new ConsumerThread();
            this.consumerThread.start();
        }
    }

    static {
        SequenceLoggerImpl logger = new SequenceLoggerImpl();
        logger.start();
        INSTANCE = logger;
    }

    private static class FlushToken
    extends Transition {
        CountDownLatch cdl = new CountDownLatch(1);

        public FlushToken() {
            super(null, null, null, null, null, null);
        }
    }

    private class ConsumerThread
    extends Thread {
        public ConsumerThread() {
            super("State Logger Consumer Thread");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Transition edge;
                        if ((edge = (Transition)SequenceLoggerImpl.this.edges.take()) instanceof FlushToken) {
                            ((FlushToken)edge).cdl.countDown();
                            continue;
                        }
                        if (SequenceLoggerImpl.this.appender == null) continue;
                        SequenceLoggerImpl.this.appender.write(edge);
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    SequenceLoggerImpl.this.appender.close();
                    SequenceLoggerImpl.this.appender = null;
                    continue;
                }
                break;
            }
        }
    }
}

