/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.process;

import org.apache.commons.lang3.Validate;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.process.StartupStatusListener;
import org.apache.logging.log4j.Logger;

public class StartupStatus {
    private static final Logger logger = LogService.getLogger();
    @MakeNotStatic
    private static StartupStatusListener listener;

    private StartupStatus() {
    }

    public static synchronized void startup(String msg, Object ... params) {
        Validate.notNull((Object)msg, (String)("Invalid msgId '" + msg + "' specified"), (Object[])new Object[0]);
        Validate.notNull((Object)params, (String)"Invalid params specified", (Object[])new Object[0]);
        String message = String.format(msg, params);
        if (listener != null) {
            listener.setStatus(message);
        }
        logger.info(message);
    }

    public static synchronized void setListener(StartupStatusListener listener) {
        StartupStatus.listener = listener;
    }

    public static synchronized StartupStatusListener getStartupListener() {
        return listener;
    }

    public static synchronized void clearListener() {
        listener = null;
    }
}

