/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.process;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.Validate;
import org.apache.geode.internal.process.FileProcessController;
import org.apache.geode.internal.process.MBeanOrFileProcessController;
import org.apache.geode.internal.process.PidFile;
import org.apache.geode.internal.process.ProcessController;
import org.apache.geode.internal.process.ProcessControllerParameters;

public class ProcessControllerFactory {
    public static final String PROPERTY_DISABLE_ATTACH_API = "gemfire.test.ProcessControllerFactory.DisableAttachApi";
    private final boolean disableAttachApi = Boolean.getBoolean("gemfire.test.ProcessControllerFactory.DisableAttachApi");

    public ProcessController createProcessController(ProcessControllerParameters parameters, int pid) {
        Validate.notNull((Object)parameters, (String)("Invalid parameters '" + parameters + "' specified"), (Object[])new Object[0]);
        Validate.isTrue((pid > 0 ? 1 : 0) != 0, (String)("Invalid pid '" + pid + "' specified"), (Object[])new Object[0]);
        if (!this.isAttachAPIFound()) {
            return new FileProcessController(parameters, pid);
        }
        return new MBeanOrFileProcessController(parameters, pid);
    }

    public ProcessController createProcessController(ProcessControllerParameters parameters, File directory, String pidFileName) throws IOException, InterruptedException, TimeoutException {
        Validate.notNull((Object)parameters, (String)("Invalid parameters '" + parameters + "' specified"), (Object[])new Object[0]);
        Validate.notNull((Object)directory, (String)("Invalid directory '" + directory + "' specified"), (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)pidFileName, (String)("Invalid pidFileName '" + pidFileName + "' specified"), (Object[])new Object[0]);
        return this.createProcessController(parameters, this.readPid(directory, pidFileName));
    }

    public boolean isAttachAPIFound() {
        if (this.disableAttachApi) {
            return false;
        }
        boolean found = false;
        try {
            Class<?> virtualMachineClass = Class.forName("com.sun.tools.attach.VirtualMachine");
            found = virtualMachineClass != null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return found;
    }

    private int readPid(File directory, String pidFileName) throws IOException {
        return new PidFile(directory, pidFileName).readPid();
    }
}

