/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.offheap;

import org.apache.geode.OutOfOffHeapMemoryException;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.internal.logging.LoggingThread;
import org.apache.geode.internal.offheap.OutOfOffHeapMemoryListener;

class DisconnectingOutOfOffHeapMemoryListener
implements OutOfOffHeapMemoryListener {
    private final Object lock = new Object();
    private InternalDistributedSystem ids;

    DisconnectingOutOfOffHeapMemoryListener(InternalDistributedSystem ids) {
        this.ids = ids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            this.ids = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void outOfOffHeapMemory(final OutOfOffHeapMemoryException cause) {
        Object object = this.lock;
        synchronized (object) {
            if (this.ids == null) {
                return;
            }
            if (Boolean.getBoolean("gemfire.offheap.stayConnectedOnOutOfOffHeapMemory")) {
                return;
            }
            final InternalDistributedSystem dsToDisconnect = this.ids;
            this.ids = null;
            if (dsToDisconnect.getDistributionManager().getRootCause() == null) {
                dsToDisconnect.getDistributionManager().setRootCause(cause);
            }
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    dsToDisconnect.getLogWriter().info("OffHeapStorage about to invoke disconnect on " + dsToDisconnect);
                    dsToDisconnect.disconnect(cause.getMessage(), cause, false);
                }
            };
            String name = this.getClass().getSimpleName() + "@" + this.hashCode() + " Handle OutOfOffHeapMemoryException Thread";
            LoggingThread thread = new LoggingThread(name, runnable);
            thread.start();
        }
    }
}

