/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.monitoring.executor;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.text.SimpleDateFormat;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.monitoring.ThreadsMonitoring;
import org.apache.logging.log4j.Logger;

public abstract class AbstractExecutor {
    private static final int THREAD_DUMP_DEPTH = 40;
    private static final Logger logger = LogService.getLogger();
    private long threadID;
    private String groupName;
    private short numIterationsStuck = 0;
    private long startTime = System.currentTimeMillis();

    public AbstractExecutor(ThreadsMonitoring tMonitoring) {
        this.threadID = Thread.currentThread().getId();
    }

    public AbstractExecutor(ThreadsMonitoring tMonitoring, long threadID) {
        this.threadID = threadID;
    }

    public void handleExpiry(long stuckTime) {
        this.incNumIterationsStuck();
        logger.warn(this.handleLogMessage(stuckTime));
    }

    private String handleLogMessage(long stuckTime) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd MMM yyyy HH:mm:ss zzz");
        ThreadInfo thread = ManagementFactory.getThreadMXBean().getThreadInfo(this.threadID, 40);
        boolean logThreadDetails = thread != null;
        StringBuilder strb = new StringBuilder();
        strb.append("Thread <").append(this.threadID).append("> that was executed at <").append(dateFormat.format(this.getStartTime())).append("> has been stuck for <").append((float)stuckTime / 1000.0f).append(" seconds> and number of thread monitor iteration <").append(this.numIterationsStuck).append("> ").append(System.lineSeparator());
        if (logThreadDetails) {
            strb.append("Thread Name <").append(thread.getThreadName()).append(">").append(System.lineSeparator()).append("Thread state <").append((Object)thread.getThreadState()).append(">").append(System.lineSeparator());
            if (thread.getLockName() != null) {
                strb.append("Waiting on <").append(thread.getLockName()).append(">").append(System.lineSeparator());
            }
            if (thread.getLockOwnerName() != null) {
                strb.append("Owned By <").append(thread.getLockOwnerName()).append("> and ID <").append(thread.getLockOwnerId()).append(">").append(System.lineSeparator());
            }
        }
        strb.append("Executor Group <").append(this.groupName).append(">").append(System.lineSeparator()).append("Monitored metric <ResourceManagerStats.numThreadsStuck>").append(System.lineSeparator());
        if (logThreadDetails) {
            strb.append("Thread Stack:").append(System.lineSeparator());
            for (int i = 0; i < thread.getStackTrace().length; ++i) {
                String row = thread.getStackTrace()[i].toString();
                strb.append(row).append(System.lineSeparator());
            }
        }
        return strb.toString();
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long newTime) {
        this.startTime = newTime;
    }

    public short getNumIterationsStuck() {
        return this.numIterationsStuck;
    }

    public void incNumIterationsStuck() {
        this.numIterationsStuck = (short)(this.numIterationsStuck + 1);
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public long getThreadID() {
        return this.threadID;
    }
}

