/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.metrics;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import java.util.Collection;
import java.util.HashSet;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.internal.cache.CacheLifecycleListener;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.util.CollectingServiceLoader;
import org.apache.geode.internal.util.ListCollectingServiceLoader;
import org.apache.geode.metrics.MetricsPublishingService;
import org.apache.geode.metrics.MetricsSession;

public class CacheLifecycleMetricsSession
implements MetricsSession,
CacheLifecycleListener {
    private final CacheLifecycle cacheLifecycle;
    private final CompositeMeterRegistry registry;
    private final Collection<MetricsPublishingService> metricsPublishingServices;

    public static Builder builder() {
        return new Builder();
    }

    @VisibleForTesting
    CacheLifecycleMetricsSession(CacheLifecycle cacheLifecycle, CompositeMeterRegistry registry, Collection<MetricsPublishingService> metricsPublishingServices) {
        this.cacheLifecycle = cacheLifecycle;
        this.registry = registry;
        this.metricsPublishingServices = metricsPublishingServices;
    }

    @Override
    public void addSubregistry(MeterRegistry subregistry) {
        this.registry.add(subregistry);
    }

    @Override
    public void removeSubregistry(MeterRegistry subregistry) {
        this.registry.remove(subregistry);
    }

    @Override
    public void cacheCreated(InternalCache cache) {
        for (MetricsPublishingService metricsPublishingService : this.metricsPublishingServices) {
            metricsPublishingService.start(this);
        }
    }

    @Override
    public void cacheClosed(InternalCache cache) {
        this.cacheLifecycle.removeListener(this);
        for (MetricsPublishingService metricsPublishingService : this.metricsPublishingServices) {
            metricsPublishingService.stop();
        }
        for (MeterRegistry downstream : new HashSet(this.registry.getRegistries())) {
            this.removeSubregistry(downstream);
        }
    }

    @VisibleForTesting
    CompositeMeterRegistry meterRegistry() {
        return this.registry;
    }

    @VisibleForTesting
    Collection<MetricsPublishingService> metricsPublishingServices() {
        return this.metricsPublishingServices;
    }

    @VisibleForTesting
    static interface CacheLifecycle {
        default public void addListener(CacheLifecycleListener listener) {
            GemFireCacheImpl.addCacheLifecycleListener(listener);
        }

        default public void removeListener(CacheLifecycleListener listener) {
            GemFireCacheImpl.removeCacheLifecycleListener(listener);
        }
    }

    public static class Builder {
        private CollectingServiceLoader serviceLoader = new ListCollectingServiceLoader();
        private CacheLifecycle cacheLifecycle = new CacheLifecycle(){};

        private Builder() {
        }

        @VisibleForTesting
        Builder setCacheLifecycle(CacheLifecycle cacheLifecycle) {
            this.cacheLifecycle = cacheLifecycle;
            return this;
        }

        @VisibleForTesting
        Builder setServiceLoader(CollectingServiceLoader serviceLoader) {
            this.serviceLoader = serviceLoader;
            return this;
        }

        public CacheLifecycleMetricsSession build(CompositeMeterRegistry registry) {
            Collection<MetricsPublishingService> services = this.serviceLoader.loadServices(MetricsPublishingService.class);
            CacheLifecycleMetricsSession cacheLifecycleMetricsSession = new CacheLifecycleMetricsSession(this.cacheLifecycle, registry, services);
            this.cacheLifecycle.addListener(cacheLifecycleMetricsSession);
            return cacheLifecycleMetricsSession;
        }
    }
}

