/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.logging.log4j;

import org.apache.geode.internal.logging.LogWriterLevel;
import org.apache.logging.log4j.Level;

public class LogWriterLevelConverter {
    public static Level toLevel(LogWriterLevel logWriterLevel) {
        switch (logWriterLevel) {
            case ALL: {
                return Level.ALL;
            }
            case SEVERE: {
                return Level.FATAL;
            }
            case ERROR: {
                return Level.ERROR;
            }
            case WARNING: {
                return Level.WARN;
            }
            case INFO: {
                return Level.INFO;
            }
            case CONFIG: {
                return Level.INFO;
            }
            case FINE: {
                return Level.DEBUG;
            }
            case FINER: {
                return Level.TRACE;
            }
            case FINEST: {
                return Level.TRACE;
            }
            case NONE: {
                return Level.OFF;
            }
        }
        throw new IllegalArgumentException("No matching Log4J2 Level for " + (Object)((Object)logWriterLevel) + ".");
    }

    public static LogWriterLevel fromLevel(Level level) {
        if (level == Level.ALL) {
            return LogWriterLevel.ALL;
        }
        if (level == Level.FATAL) {
            return LogWriterLevel.SEVERE;
        }
        if (level == Level.ERROR) {
            return LogWriterLevel.ERROR;
        }
        if (level == Level.WARN) {
            return LogWriterLevel.WARNING;
        }
        if (level == Level.INFO) {
            return LogWriterLevel.INFO;
        }
        if (level == Level.DEBUG) {
            return LogWriterLevel.FINE;
        }
        if (level == Level.TRACE) {
            return LogWriterLevel.FINEST;
        }
        if (level == Level.OFF) {
            return LogWriterLevel.NONE;
        }
        throw new IllegalArgumentException("No matching AlertLevel for Log4J2 Level " + level + ".");
    }
}

