/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.logging.log4j;

import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.message.MessageFactory;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.apache.logging.log4j.spi.ExtendedLoggerWrapper;
import org.apache.logging.log4j.status.StatusLogger;

public class FastLogger
extends ExtendedLoggerWrapper {
    private static final long serialVersionUID = 7084130827962463327L;
    @MakeNotStatic
    private static volatile boolean delegating = true;

    public FastLogger(Logger logger) {
        this((ExtendedLogger)logger, logger.getName(), logger.getMessageFactory());
    }

    public FastLogger(ExtendedLogger logger, String name, MessageFactory messageFactory) {
        super(logger, name, messageFactory);
    }

    public static void setDelegating(boolean newValue) {
        StatusLogger.getLogger().debug("Setting delegating to {}", (Object)newValue);
        delegating = newValue;
    }

    public boolean isDebugEnabled() {
        return delegating && super.isDebugEnabled();
    }

    public boolean isDebugEnabled(Marker marker) {
        return delegating && super.isDebugEnabled(marker);
    }

    public boolean isTraceEnabled() {
        return delegating && super.isTraceEnabled();
    }

    public boolean isTraceEnabled(Marker marker) {
        return delegating && super.isTraceEnabled(marker);
    }

    public boolean isDelegating() {
        return delegating;
    }

    public ExtendedLogger getExtendedLogger() {
        return this.logger;
    }
}

