/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.logging;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.TreeSet;
import org.apache.commons.lang3.SystemUtils;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.internal.ExitCode;
import org.apache.geode.internal.logging.LogFileParser;

public class SortLogFile {
    @Immutable
    private static final PrintStream out = System.out;
    @Immutable
    private static final PrintStream err = System.err;

    public static void sortLogFile(InputStream logFile, PrintWriter sortedFile) throws IOException {
        TreeSet<LogFileParser.LogEntry> sorted = new TreeSet<LogFileParser.LogEntry>((entry1, entry2) -> {
            String stamp2;
            String stamp1 = entry1.getTimestamp();
            if (stamp1.equals(stamp2 = entry2.getTimestamp())) {
                if (entry1.getContents().equals(entry2.getContents())) {
                    return Integer.valueOf(entry1.hashCode()).compareTo(entry2.hashCode());
                }
                return entry1.getContents().compareTo(entry2.getContents());
            }
            return stamp1.compareTo(stamp2);
        });
        BufferedReader br = new BufferedReader(new InputStreamReader(logFile));
        LogFileParser parser = new LogFileParser(null, br);
        while (parser.hasMoreEntries()) {
            sorted.add(parser.getNextEntry());
        }
        for (LogFileParser.LogEntry entry : sorted) {
            entry.writeTo(sortedFile);
        }
    }

    private static void usage(String s) {
        err.println(SystemUtils.LINE_SEPARATOR + "** " + s + SystemUtils.LINE_SEPARATOR);
        err.println("Usage: java SortLogFile logFile");
        err.println("-sortedFile file File in which to put sorted log");
        err.println();
        err.println("Sorts a GemFire log file by timestamp. The merged log file is written to System.out (or a file).");
        err.println();
        ExitCode.FATAL.doSystemExit();
    }

    public static void main(String ... args) throws IOException {
        File logFile = null;
        File sortedFile = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-sortedFile")) {
                if (++i >= args.length) {
                    SortLogFile.usage("Missing sorted file name");
                }
                sortedFile = new File(args[i]);
                continue;
            }
            if (logFile == null) {
                File file = new File(args[i]);
                if (!file.exists()) {
                    SortLogFile.usage(String.format("File %s does not exist", file));
                }
                logFile = file;
                continue;
            }
            SortLogFile.usage(String.format("Extraneous command line: %s", args[i]));
        }
        if (logFile == null) {
            SortLogFile.usage("Missing filename");
        }
        FileInputStream logFileStream = new FileInputStream(logFile);
        PrintStream ps = sortedFile != null ? new PrintStream(new FileOutputStream(sortedFile), true) : out;
        PrintWriter pw = new PrintWriter(ps, true);
        SortLogFile.sortLogFile(logFileStream, pw);
        ExitCode.NORMAL.doSystemExit();
    }
}

