/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.logging;

import java.util.ServiceLoader;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.internal.ClassPathLoader;
import org.apache.geode.internal.logging.DefaultProviderChecker;
import org.apache.geode.internal.logging.NullProviderAgent;
import org.apache.geode.internal.logging.ProviderAgent;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.status.StatusLogger;

public class ProviderAgentLoader {
    private static final Logger LOGGER = StatusLogger.getLogger();
    static final String PROVIDER_AGENT_NAME_PROPERTY = "geode.PROVIDER_AGENT_NAME";
    private final AvailabilityChecker availabilityChecker;

    public ProviderAgentLoader() {
        this(new DefaultProviderChecker());
    }

    @VisibleForTesting
    ProviderAgentLoader(AvailabilityChecker availabilityChecker) {
        this.availabilityChecker = availabilityChecker;
    }

    public boolean isDefaultAvailable() {
        return this.availabilityChecker.isAvailable();
    }

    public ProviderAgent findProviderAgent() {
        ServiceLoader<ProviderAgent> serviceLoaderFromExt = ServiceLoader.loadInstalled(ProviderAgent.class);
        if (serviceLoaderFromExt.iterator().hasNext()) {
            ProviderAgent providerAgent = serviceLoaderFromExt.iterator().next();
            LOGGER.info("Using {} from Extension ClassLoader for service {}", (Object)providerAgent.getClass().getName(), (Object)ProviderAgent.class.getName());
            return providerAgent;
        }
        ServiceLoader<ProviderAgent> serviceLoaderFromTccl = ServiceLoader.load(ProviderAgent.class);
        if (serviceLoaderFromTccl.iterator().hasNext()) {
            ProviderAgent providerAgent = serviceLoaderFromTccl.iterator().next();
            LOGGER.info("Using {} from Thread Context ClassLoader for service {}", (Object)providerAgent.getClass().getName(), (Object)ProviderAgent.class.getName());
            return providerAgent;
        }
        ServiceLoader<ProviderAgent> serviceLoaderFromSys = ServiceLoader.load(ProviderAgent.class, null);
        if (serviceLoaderFromSys.iterator().hasNext()) {
            ProviderAgent providerAgent = serviceLoaderFromSys.iterator().next();
            LOGGER.info("Using {} from System ClassLoader for service {}", (Object)providerAgent.getClass().getName(), (Object)ProviderAgent.class.getName());
            return providerAgent;
        }
        return this.createProviderAgent();
    }

    ProviderAgent createProviderAgent() {
        if (System.getProperty(PROVIDER_AGENT_NAME_PROPERTY) == null && !this.isDefaultAvailable()) {
            return new NullProviderAgent();
        }
        String agentClassName = System.getProperty(PROVIDER_AGENT_NAME_PROPERTY, "org.apache.geode.internal.logging.log4j.Log4jAgent");
        try {
            Class<ProviderAgent> agentClass = ClassPathLoader.getLatest().forName(agentClassName).asSubclass(ProviderAgent.class);
            ProviderAgent providerAgent = agentClass.newInstance();
            if ("org.apache.geode.internal.logging.log4j.Log4jAgent".equals(providerAgent.getClass().getName())) {
                LOGGER.info("Using {} by default for service {}", (Object)providerAgent.getClass().getName(), (Object)ProviderAgent.class.getName());
            } else {
                LOGGER.info("Using {} from System Property {} for service {}", (Object)providerAgent.getClass().getName(), (Object)PROVIDER_AGENT_NAME_PROPERTY, (Object)ProviderAgent.class.getName());
            }
            return providerAgent;
        }
        catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            LOGGER.warn("Unable to create ProviderAgent of type {}", (Object)agentClassName, (Object)e);
            LOGGER.info("Using {} for service {}", (Object)NullProviderAgent.class.getName(), (Object)PROVIDER_AGENT_NAME_PROPERTY, (Object)ProviderAgent.class.getName());
            return new NullProviderAgent();
        }
    }

    static interface AvailabilityChecker {
        public boolean isAvailable();
    }
}

