/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.logging;

import java.text.MessageFormat;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.geode.SystemFailure;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public class LoggingUncaughtExceptionHandler {
    @Immutable
    private static final Implementation handler = new Implementation(LogService.getLogger(), error -> SystemFailure.setFailure(error));

    public static Thread.UncaughtExceptionHandler getInstance() {
        return handler;
    }

    public static void setOnThread(Thread thread) {
        handler.setOnThread(thread);
    }

    public static int getUncaughtExceptionsCount() {
        return handler.getUncaughtExceptionsCount();
    }

    public static void clearUncaughtExceptionsCount() {
        handler.clearUncaughtExceptionsCount();
    }

    LoggingUncaughtExceptionHandler() {
    }

    static class Implementation
    implements Thread.UncaughtExceptionHandler {
        private final Logger logger;
        private final FailureSetter failureSetter;
        private final AtomicInteger uncaughtExceptionsCount = new AtomicInteger();

        Implementation(Logger logger, FailureSetter failureSetter) {
            this.logger = logger;
            this.failureSetter = failureSetter;
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            if (e instanceof VirtualMachineError) {
                this.failureSetter.setFailure((VirtualMachineError)e);
            }
            if (e instanceof NoClassDefFoundError && t.getName().equals("Distributed system shutdown hook")) {
                this.logger.info("Uncaught exception in thread {} this message can be disregarded if it occurred during an Application Server shutdown. The Exception message was: {}", (Object)t, (Object)e);
            } else {
                String message = MessageFormat.format("Uncaught exception in thread {0}", t);
                this.logger.fatal(message, e);
            }
            this.uncaughtExceptionsCount.incrementAndGet();
        }

        void setOnThread(Thread thread) {
            thread.setUncaughtExceptionHandler(this);
        }

        int getUncaughtExceptionsCount() {
            return this.uncaughtExceptionsCount.get();
        }

        void clearUncaughtExceptionsCount() {
            this.uncaughtExceptionsCount.set(0);
        }
    }

    static interface FailureSetter {
        public void setFailure(VirtualMachineError var1);
    }
}

