/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.logging;

import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.internal.logging.LogFile;
import org.apache.geode.internal.logging.LoggingSessionListener;
import org.apache.geode.internal.logging.SessionContext;

public class LoggingSessionListeners {
    @MakeNotStatic
    private static final LoggingSessionListeners INSTANCE = new LoggingSessionListeners();
    private final Set<LoggingSessionListener> listeners = new LinkedHashSet<LoggingSessionListener>();

    public static LoggingSessionListeners get() {
        return INSTANCE;
    }

    @VisibleForTesting
    LoggingSessionListeners() {
    }

    public void addLoggingLifecycleListener(LoggingSessionListener listener) {
        this.listeners.add(listener);
    }

    public void removeLoggingLifecycleListener(LoggingSessionListener listener) {
        this.listeners.remove(listener);
    }

    public void clear() {
        this.listeners.clear();
    }

    public void createSession(SessionContext sessionContext) {
        for (LoggingSessionListener listener : this.listeners) {
            listener.createSession(sessionContext);
        }
    }

    public void startSession() {
        for (LoggingSessionListener listener : this.listeners) {
            listener.startSession();
        }
    }

    public void stopSession() {
        for (LoggingSessionListener listener : this.listeners) {
            listener.stopSession();
        }
    }

    public Optional<LogFile> getLogFile() {
        for (LoggingSessionListener listener : this.listeners) {
            if (!listener.getLogFile().isPresent()) continue;
            return listener.getLogFile();
        }
        return Optional.empty();
    }
}

