/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.logging;

import java.util.logging.Handler;
import java.util.logging.LogRecord;
import org.apache.geode.GemFireException;
import org.apache.geode.LogWriter;
import org.apache.geode.internal.logging.GemFireFormatter;
import org.apache.geode.internal.logging.LogWriterImpl;
import org.apache.geode.internal.logging.log4j.LogWriterLogger;

public class GemFireHandler
extends Handler {
    private LogWriter logWriter;

    public GemFireHandler(LogWriter logWriter) {
        this.logWriter = logWriter;
        this.setFormatter(new GemFireFormatter());
    }

    @Override
    public void close() {
        this.logWriter = null;
    }

    @Override
    public void flush() {
    }

    private String getMessage(LogRecord record) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(').append("tid=").append(record.getThreadID()).append(" msgId=").append(record.getSequenceNumber()).append(") ");
        if (record.getMessage() != null) {
            stringBuilder.append(this.getFormatter().formatMessage(record));
        }
        return stringBuilder.toString();
    }

    @Override
    public void publish(LogRecord record) {
        if (this.isLoggable(record)) {
            try {
                if (this.logWriter instanceof LogWriterLogger) {
                    ((LogWriterLogger)this.logWriter).log(record.getLevel().intValue(), this.getMessage(record), record.getThrown());
                } else {
                    ((LogWriterImpl)this.logWriter).put(record.getLevel().intValue(), this.getMessage(record), record.getThrown());
                }
            }
            catch (GemFireException ex) {
                this.reportError(null, ex, 1);
            }
        }
    }
}

