/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.logging;

import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.internal.ClassPathLoader;
import org.apache.geode.internal.logging.ProviderAgentLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.status.StatusLogger;

class DefaultProviderChecker
implements ProviderAgentLoader.AvailabilityChecker {
    static final String DEFAULT_PROVIDER_AGENT_NAME = "org.apache.geode.internal.logging.log4j.Log4jAgent";
    static final String DEFAULT_PROVIDER_CLASS_NAME = "org.apache.logging.log4j.core.impl.Log4jContextFactory";
    private final Supplier<Class> contextFactoryClassSupplier;
    private final Function<String, Boolean> isClassLoadableFunction;
    private final Logger logger;

    DefaultProviderChecker() {
        this(() -> LogManager.getFactory().getClass(), DefaultProviderChecker::isClassLoadable, (Logger)StatusLogger.getLogger());
    }

    @VisibleForTesting
    DefaultProviderChecker(Supplier<Class> contextFactoryClassSupplier, Function<String, Boolean> isClassLoadableFunction, Logger logger) {
        this.contextFactoryClassSupplier = contextFactoryClassSupplier;
        this.isClassLoadableFunction = isClassLoadableFunction;
        this.logger = logger;
    }

    @Override
    public boolean isAvailable() {
        if (!this.isClassLoadableFunction.apply(DEFAULT_PROVIDER_CLASS_NAME).booleanValue()) {
            this.logger.info("Unable to find Log4j Core.");
            return false;
        }
        boolean usingLog4jProvider = DEFAULT_PROVIDER_CLASS_NAME.equals(this.contextFactoryClassSupplier.get().getName());
        String message = "Log4j Core is available " + (usingLog4jProvider ? "and using" : "but not using") + " Log4jProvider.";
        this.logger.info(message);
        return usingLog4jProvider;
    }

    @VisibleForTesting
    static boolean isClassLoadable(String className) {
        try {
            ClassPathLoader.getLatest().forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

