/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.logging;

import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.internal.logging.LogConfig;
import org.apache.geode.internal.logging.LogConfigListener;
import org.apache.geode.internal.logging.LogConfigSupplier;
import org.apache.geode.internal.logging.LogLevelUpdateOccurs;
import org.apache.geode.internal.logging.LogLevelUpdateScope;
import org.apache.geode.internal.logging.LogWriterLevel;
import org.apache.geode.internal.logging.ProviderAgent;
import org.apache.geode.internal.logging.ProviderAgentLoader;

public class Configuration
implements LogConfigListener {
    @VisibleForTesting
    public static final int DEFAULT_LOGWRITER_LEVEL = LogWriterLevel.CONFIG.intLevel();
    public static final String STARTUP_CONFIGURATION = "Startup Configuration: ";
    public static final String CLI_CONFIG = "/log4j2-cli.xml";
    public static final String GEODE_LOGGER_PREFIX = "org.apache.geode";
    public static final String MAIN_LOGGER_NAME = "org.apache.geode";
    public static final String SECURITY_LOGGER_NAME = "org.apache.geode.security";
    public static final String LOG_LEVEL_UPDATE_OCCURS_PROPERTY = "geode.LOG_LEVEL_UPDATE_OCCURS";
    static final String LOG_LEVEL_UPDATE_SCOPE_PROPERTY = "geode.LOG_LEVEL_UPDATE_SCOPE";
    private final LogLevelUpdateOccurs logLevelUpdateOccurs;
    private final LogLevelUpdateScope logLevelUpdateScope;
    private final ProviderAgent providerAgent;
    private LogConfigSupplier logConfigSupplier;

    public static Configuration create() {
        return Configuration.create(Configuration.getLogLevelUpdateOccurs(), Configuration.getLogLevelUpdateScope(), new ProviderAgentLoader().findProviderAgent());
    }

    @VisibleForTesting
    public static Configuration create(ProviderAgent providerAgent) {
        return Configuration.create(Configuration.getLogLevelUpdateOccurs(), Configuration.getLogLevelUpdateScope(), providerAgent);
    }

    @VisibleForTesting
    public static Configuration create(LogLevelUpdateOccurs logLevelUpdateOccurs, LogLevelUpdateScope logLevelUpdateScope) {
        return Configuration.create(logLevelUpdateOccurs, logLevelUpdateScope, new ProviderAgentLoader().findProviderAgent());
    }

    @VisibleForTesting
    public static Configuration create(LogLevelUpdateOccurs logLevelUpdateOccurs, LogLevelUpdateScope logLevelUpdateScope, ProviderAgent providerAgent) {
        return new Configuration(logLevelUpdateOccurs, logLevelUpdateScope, providerAgent);
    }

    private Configuration(LogLevelUpdateOccurs logLevelUpdateOccurs, LogLevelUpdateScope logLevelUpdateScope, ProviderAgent providerAgent) {
        this.logLevelUpdateOccurs = logLevelUpdateOccurs;
        this.logLevelUpdateScope = logLevelUpdateScope;
        this.providerAgent = providerAgent;
    }

    static LogLevelUpdateOccurs getLogLevelUpdateOccurs() {
        try {
            return LogLevelUpdateOccurs.valueOf(System.getProperty(LOG_LEVEL_UPDATE_OCCURS_PROPERTY, LogLevelUpdateOccurs.ONLY_WHEN_USING_DEFAULT_CONFIG.name()).toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return LogLevelUpdateOccurs.ONLY_WHEN_USING_DEFAULT_CONFIG;
        }
    }

    static LogLevelUpdateScope getLogLevelUpdateScope() {
        try {
            return LogLevelUpdateScope.valueOf(System.getProperty(LOG_LEVEL_UPDATE_SCOPE_PROPERTY, LogLevelUpdateScope.GEODE_LOGGERS.name()).toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return LogLevelUpdateScope.GEODE_LOGGERS;
        }
    }

    public synchronized void initialize(LogConfigSupplier logConfigSupplier) {
        if (logConfigSupplier == null) {
            throw new IllegalArgumentException("LogConfigSupplier must not be null");
        }
        this.logConfigSupplier = logConfigSupplier;
        logConfigSupplier.addLogConfigListener(this);
        this.configChanged();
    }

    @Override
    public synchronized void configChanged() {
        if (this.logConfigSupplier == null) {
            throw new IllegalStateException("LogConfigSupplier must not be null");
        }
        LogConfig logConfig = this.logConfigSupplier.getLogConfig();
        this.providerAgent.configure(logConfig, this.logLevelUpdateOccurs, this.logLevelUpdateScope);
    }

    public synchronized void shutdown() {
        if (this.logConfigSupplier != null) {
            this.logConfigSupplier.removeLogConfigListener(this);
            this.logConfigSupplier = null;
        }
        this.providerAgent.cleanup();
    }

    String getConfigurationInfo() {
        return this.providerAgent.getConfigurationInfo();
    }

    void enableLoggingToStandardOutput() {
        LogConfig logConfig = this.logConfigSupplier.getLogConfig();
        if (logConfig.getLogFile().exists()) {
            this.providerAgent.enableLoggingToStandardOutput();
        }
    }

    void disableLoggingToStandardOutputIfLoggingToFile() {
        LogConfig logConfig = this.logConfigSupplier.getLogConfig();
        if (logConfig.getLogFile().exists()) {
            this.providerAgent.disableLoggingToStandardOutput();
        }
    }

    @VisibleForTesting
    synchronized LogConfigSupplier getLogConfigSupplier() {
        return this.logConfigSupplier;
    }
}

