/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.datasource;

import java.util.HashMap;
import java.util.Map;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.security.auth.Subject;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.apache.geode.internal.datasource.ConfiguredDataSourceProperties;
import org.apache.geode.internal.datasource.ConnectionPoolCache;
import org.apache.geode.internal.datasource.ManagedPoolCacheImpl;
import org.apache.geode.internal.datasource.PoolException;
import org.apache.geode.internal.jndi.JNDIInvoker;
import org.apache.geode.internal.jta.TransactionManagerImpl;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public class JCAConnectionManagerImpl
implements ConnectionManager,
ConnectionEventListener {
    private static final Logger logger = LogService.getLogger();
    private static final long serialVersionUID = 5281512854051120661L;
    protected transient TransactionManager transManager;
    protected ConnectionPoolCache mannPoolCache;
    protected ConnectionRequestInfo conReqInfo = null;
    protected Subject subject = null;
    protected Map xaResourcesMap = new HashMap();
    protected boolean isActive = true;

    public JCAConnectionManagerImpl(ManagedConnectionFactory mcf, ConfiguredDataSourceProperties configs) {
        try {
            this.isActive = true;
            this.mannPoolCache = new ManagedPoolCacheImpl(mcf, null, null, this, configs);
        }
        catch (Exception ex) {
            logger.fatal(String.format("JCAConnectionManagerImpl::Constructor: An exception was caught while initialising due to %s", ex.getLocalizedMessage()), (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object allocateConnection(ManagedConnectionFactory mcf, ConnectionRequestInfo reqInfo) throws ResourceException {
        if (!this.isActive) {
            throw new ResourceException("JCAConnectionManagerImpl::allocateConnection::No valid Connection available");
        }
        ManagedConnection conn = null;
        try {
            conn = (ManagedConnection)this.mannPoolCache.getPooledConnectionFromPool();
        }
        catch (PoolException ex) {
            throw new ResourceException(String.format("JCAConnectionManagerImpl:: allocateConnection : in getting connection from pool due to %s", ex.getMessage()), (Throwable)ex);
        }
        try {
            JCAConnectionManagerImpl ex = this;
            synchronized (ex) {
                if (this.transManager == null) {
                    this.transManager = JNDIInvoker.getTransactionManager();
                }
            }
            Transaction txn = this.transManager.getTransaction();
            if (txn != null) {
                XAResource xar = conn.getXAResource();
                txn.enlistResource(xar);
                this.xaResourcesMap.put(conn, xar);
            }
        }
        catch (RollbackException ex) {
            throw new ResourceException(String.format("JCAConnectionManagerImpl:: allocateConnection : in transaction due to %s", ex.getMessage()), (Throwable)ex);
        }
        catch (SystemException ex) {
            throw new ResourceException(String.format("JCAConnectionManagerImpl:: allocateConnection :system exception due to %s", ex.getMessage()), (Throwable)ex);
        }
        return conn.getConnection(this.subject, reqInfo);
    }

    public void connectionErrorOccurred(ConnectionEvent event) {
        block6: {
            if (this.isActive) {
                ManagedConnection conn = (ManagedConnection)event.getSource();
                XAResource xar = (XAResource)this.xaResourcesMap.get(conn);
                this.xaResourcesMap.remove(conn);
                TransactionManagerImpl transManager = TransactionManagerImpl.getTransactionManager();
                try {
                    Transaction txn = transManager.getTransaction();
                    if (txn != null && xar != null) {
                        txn.delistResource(xar, 0x4000000);
                    }
                }
                catch (SystemException se) {
                    se.printStackTrace();
                }
                try {
                    this.mannPoolCache.expirePooledConnection(conn);
                }
                catch (Exception ex) {
                    String exception = "JCAConnectionManagerImpl::connectionErrorOccurred: Exception occurred due to " + ex;
                    if (!logger.isDebugEnabled()) break block6;
                    logger.debug(exception, (Throwable)ex);
                }
            }
        }
    }

    public void connectionClosed(ConnectionEvent event) {
        if (this.isActive) {
            ManagedConnection conn;
            block5: {
                conn = (ManagedConnection)event.getSource();
                XAResource xar = null;
                if (this.xaResourcesMap.get(conn) != null) {
                    xar = (XAResource)this.xaResourcesMap.get(conn);
                }
                this.xaResourcesMap.remove(conn);
                try {
                    Transaction txn = this.transManager.getTransaction();
                    if (txn != null && xar != null) {
                        txn.delistResource(xar, 0x4000000);
                    }
                }
                catch (Exception se) {
                    String exception = "JCAConnectionManagerImpl::connectionClosed: Exception occurred due to " + se;
                    if (!logger.isDebugEnabled()) break block5;
                    logger.debug(exception, (Throwable)se);
                }
            }
            this.mannPoolCache.returnPooledConnectionToPool(conn);
        }
    }

    public void localTransactionCommitted(ConnectionEvent arg0) {
    }

    public void localTransactionRolledback(ConnectionEvent arg0) {
    }

    public void localTransactionStarted(ConnectionEvent arg0) {
    }

    public void clearUp() {
        this.isActive = false;
        this.mannPoolCache.clearUp();
    }
}

