/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.datasource;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.apache.geode.internal.datasource.AbstractDataSource;
import org.apache.geode.internal.datasource.ConfiguredDataSourceProperties;
import org.apache.geode.internal.datasource.ConnectionProvider;
import org.apache.geode.internal.datasource.GemFireConnectionPoolManager;
import org.apache.geode.internal.jndi.JNDIInvoker;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public class GemFireTransactionDataSource
extends AbstractDataSource
implements ConnectionEventListener {
    private static final Logger logger = LogService.getLogger();
    private static final long serialVersionUID = -3095123666092414103L;
    private transient TransactionManager transManager;
    ConnectionProvider provider;
    private Map xaResourcesMap = Collections.synchronizedMap(new HashMap());

    public boolean isWrapperFor(Class iface) throws SQLException {
        return true;
    }

    public Object unwrap(Class iface) throws SQLException {
        return iface;
    }

    public GemFireTransactionDataSource(XADataSource xaDS, ConfiguredDataSourceProperties configs) throws SQLException {
        super(configs);
        if (xaDS == null || configs == null) {
            throw new SQLException("GemFireTransactionDataSource::XADataSource class object is null or ConfiguredDataSourceProperties object is null");
        }
        try {
            this.provider = new GemFireConnectionPoolManager(xaDS, configs, (ConnectionEventListener)this);
            this.transManager = JNDIInvoker.getTransactionManager();
        }
        catch (Exception ex) {
            String exception = "GemFireTransactionDataSource::Exception = " + ex;
            if (logger.isDebugEnabled()) {
                logger.debug(exception, (Throwable)ex);
            }
            throw new SQLException(exception);
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (!this.isActive) {
            throw new SQLException("GemFireTransactionDataSource::getConnection::No valid Connection available");
        }
        XAConnection xaConn = null;
        try {
            xaConn = (XAConnection)this.provider.borrowConnection();
            Connection conn = this.getSQLConnection(xaConn);
            this.registerTranxConnection(xaConn);
            return conn;
        }
        catch (Exception ex) {
            SQLException se = new SQLException(ex.getMessage());
            se.initCause(ex);
            throw se;
        }
    }

    @Override
    public Connection getConnection(String clUsername, String clPassword) throws SQLException {
        this.checkCredentials(clUsername, clPassword);
        return this.getConnection();
    }

    @Override
    public void connectionClosed(ConnectionEvent event) {
        block4: {
            if (this.isActive) {
                try {
                    XAConnection conn = (XAConnection)event.getSource();
                    XAResource xar = (XAResource)this.xaResourcesMap.get(conn);
                    this.xaResourcesMap.remove(conn);
                    Transaction txn = this.transManager.getTransaction();
                    if (txn != null && xar != null) {
                        txn.delistResource(xar, 0x4000000);
                    }
                    this.provider.returnConnection(conn);
                }
                catch (Exception e) {
                    String exception = "GemFireTransactionDataSource::connectionClosed: Exception occurred due to " + e;
                    if (!logger.isDebugEnabled()) break block4;
                    logger.debug(exception, (Throwable)e);
                }
            }
        }
    }

    @Override
    public void connectionErrorOccurred(ConnectionEvent event) {
        block3: {
            if (this.isActive) {
                try {
                    PooledConnection conn = (PooledConnection)event.getSource();
                    this.provider.returnAndExpireConnection(conn);
                }
                catch (Exception ex) {
                    String exception = "GemFireTransactionDataSource::connectionErrorOccurred: Exception occurred due to " + ex;
                    if (!logger.isDebugEnabled()) break block3;
                    logger.debug(exception, (Throwable)ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerTranxConnection(XAConnection xaConn) throws Exception {
        try {
            GemFireTransactionDataSource gemFireTransactionDataSource = this;
            synchronized (gemFireTransactionDataSource) {
                if (this.transManager == null) {
                    this.transManager = JNDIInvoker.getTransactionManager();
                }
            }
            Transaction txn = this.transManager.getTransaction();
            if (txn != null) {
                XAResource xar = xaConn.getXAResource();
                txn.enlistResource(xar);
                this.xaResourcesMap.put(xaConn, xar);
            }
        }
        catch (Exception ex) {
            Exception e = new Exception(String.format("GemFireTransactionDataSource-registerTranxConnection(). Exception in registering the XAResource with the Transaction.Exception occurred= %s", ex));
            e.initCause(ex);
            throw e;
        }
    }

    protected Connection getSQLConnection(PooledConnection poolC) throws SQLException {
        Connection conn = poolC.getConnection();
        boolean val = this.validateConnection(conn);
        if (val) {
            return conn;
        }
        this.provider.returnAndExpireConnection(poolC);
        throw new SQLException("GemFireConnPooledDataSource::getConnFromConnPool:java.sql.Connection obtained is invalid");
    }

    public ConnectionProvider getConnectionProvider() {
        return this.provider;
    }

    @Override
    public void close() {
        super.close();
        this.provider.clearUp();
    }
}

