/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.datasource;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import org.apache.geode.internal.datasource.AbstractDataSource;
import org.apache.geode.internal.datasource.ConfiguredDataSourceProperties;
import org.apache.geode.internal.datasource.ConnectionProvider;
import org.apache.geode.internal.datasource.GemFireConnectionPoolManager;
import org.apache.geode.internal.datasource.PoolException;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public class GemFireConnPooledDataSource
extends AbstractDataSource
implements ConnectionEventListener {
    private static final Logger logger = LogService.getLogger();
    private static final long serialVersionUID = 1177231744410855158L;
    protected ConnectionProvider provider;

    public boolean isWrapperFor(Class iface) throws SQLException {
        return true;
    }

    public Object unwrap(Class iface) throws SQLException {
        return iface;
    }

    public GemFireConnPooledDataSource(ConnectionPoolDataSource connPoolDS, ConfiguredDataSourceProperties configs) throws SQLException {
        super(configs);
        if (connPoolDS == null || configs == null) {
            throw new SQLException("GemFireConnPooledDataSource::ConnectionPoolDataSource class object is null or ConfiguredDataSourceProperties object is null");
        }
        try {
            this.provider = new GemFireConnectionPoolManager(connPoolDS, configs, (ConnectionEventListener)this);
        }
        catch (Exception ex) {
            String exception = "An exception was caught while creating a GemFireConnectionPoolManager. %s";
            logger.error(String.format(exception, ex.getLocalizedMessage()), (Throwable)ex);
            throw new SQLException(String.format(exception, ex));
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (!this.isActive) {
            throw new SQLException("GemFireConnPooledDataSource::getConnection::No valid Connection available");
        }
        PooledConnection connPool = null;
        try {
            connPool = (PooledConnection)this.provider.borrowConnection();
        }
        catch (PoolException cpe) {
            throw new SQLException(cpe.toString());
        }
        return this.getSQLConnection(connPool);
    }

    @Override
    public Connection getConnection(String clUsername, String clPassword) throws SQLException {
        this.checkCredentials(clUsername, clPassword);
        return this.getConnection();
    }

    @Override
    public void connectionClosed(ConnectionEvent event) {
        block3: {
            if (this.isActive) {
                try {
                    PooledConnection conn = (PooledConnection)event.getSource();
                    this.provider.returnConnection(conn);
                }
                catch (Exception ex) {
                    String exception = "GemFireConnPooledDataSource::connectionclosed:Exception =" + ex;
                    if (!logger.isDebugEnabled()) break block3;
                    logger.debug(exception, (Throwable)ex);
                }
            }
        }
    }

    @Override
    public void connectionErrorOccurred(ConnectionEvent event) {
        block3: {
            if (this.isActive) {
                try {
                    PooledConnection conn = (PooledConnection)event.getSource();
                    this.provider.returnAndExpireConnection(conn);
                }
                catch (Exception ex) {
                    String exception = "GemFireConnPooledDataSource::connectionErrorOccurred:error in returning and expiring connection due to " + ex;
                    if (!logger.isDebugEnabled()) break block3;
                    logger.debug(exception, (Throwable)ex);
                }
            }
        }
    }

    @Override
    protected boolean validateConnection(Connection conn) {
        try {
            return !conn.isClosed();
        }
        catch (SQLException e) {
            return false;
        }
    }

    protected Connection getSQLConnection(PooledConnection poolC) throws SQLException {
        Connection conn = poolC.getConnection();
        boolean val = this.validateConnection(conn);
        if (val) {
            return conn;
        }
        this.provider.returnAndExpireConnection(poolC);
        throw new SQLException("GemFireConnPooledDataSource::getConnFromConnPool:java.sql.Connection obtained is invalid");
    }

    public ConnectionProvider getConnectionProvider() {
        return this.provider;
    }

    @Override
    public void close() {
        super.close();
        this.provider.clearUp();
    }
}

